/* 
 *  TFT-Gleisbelegung_V34.ino
 *
 *  Anzeige der Lok-Adressen im Schattenbahnhof
 *  schalten der Fahrstraßen zum Ausfahren
 *
 *  Libraries: SXArduino: Quellen von G.v.d.Sel
 *  https://github.com/gvandersel/SXArduino
 *  
 *  Frank Keil http://frank-keil.de/Selectrix/Sx-Decoder/Sx-Decoder.html
 *  Controller: Arduino NanoESP (5V, 16MHz), ATmega328
 *
 *  Created on: 02.01.2012
 *  Last changed on: 15.09.2025
 *  
 *  Author: fk
 *
 *  Pin2=T0=INT0, Pin4=T1, Pin3=SX-Write-High, Pin6=SX-Write-Low
 * 
 *  Belegung:
 *  5V  5V
 *   5  Helligkeit Display Achtung: muß auf Pin4 des Displays
 *   7  Select SD-Card
 *   8  Touch
 *   9  TFT_DC
 *  10  TFT_CS
 *  11
 *  12
 *  13
 *  GND GND
 * 
 *  SXbus.write(adr, val);      to set a value on an address of the SX-bus.
 *  val = SXbus.read(adr);      to get a value from the SXbus.
 *  SXbus.writePWR(val);        val = 0 for off, val = 1 for on (all other values have no influence)
 *  val = SXbus.readPWR();      val = 0 for off, val = 1 for on.
 *  
 */
 
// TFT-Teil
  #include <Adafruit_GFX.h>
  #include <SPI.h> 
  #include <Adafruit_ILI9341.h>
  #define TFT_CS 10
  #define TFT_DC 9
  Adafruit_ILI9341 tft = Adafruit_ILI9341(TFT_CS, TFT_DC);

// Touch-Teil 
  #include <Wire.h>
  #include <Adafruit_STMPE610.h>
  #define STMPE_CS 8
  Adafruit_STMPE610 ts = Adafruit_STMPE610(STMPE_CS);
  // This is calibration data for the raw touch data to the screen coordinates
  #define TS_MINX 250                               // Breite Bildschirm
  #define TS_MINY 200                               // Höhe Bildschirm
  #define TS_MAXX 3700                              // alter Wert 3800
  #define TS_MAXY 3800 

// SD-Teil
  #include <SD.h>
  File myFile; 

// Bildschirm festlegen
  #define Display_X 320                               // Breite des Displays
  #define Display_Y 240                               // Höhe des Displays
  #define Felder_X 4                                  // Anzahl der Felder in der Breite 
  #define Felder_Y 5                                  // Anzahl der Felder in der Höhe 
  #define Abstand_X 4                                 // 
  #define Abstand_Y 2                                 // 
  #define BlueField_W (Display_X/Felder_X-Abstand_X)  // 
  #define BlueField_H (Display_Y/Felder_Y-Abstand_Y)  //

  byte i = 0;                                         // Zählschleife
  byte j = 0;                                         // Zählschleife
  // byte zeile=0;
  // byte spalte=0;
  // byte vergl=0;
  byte pos=0;
  // byte lok=0;
  String myStrLok;
  String inData = ""; 
  String Baureihe[2];
  String Gattung[2];
  String LokAdr[2];

  // Sx Parameter
  #include "SXArduino.h"                        // Lib einbinden
  SXArduino SXbus(2,4,6,3);                     // Pinbelegung (Takt, Daten, Schreiben, Schreiben)
  bool noCC2000 = false;                        // false 0 ... 103, true 0 ... 111
  byte SxAdrSchreib1=0;                         // SxAdressen die geschrieben werden 
  byte SxDataSchreib1=0;                        // SxDaten die geschrieben werden  
  byte SxAdrSchreib2=0;                         // SxAdressen die geschrieben werden 
  byte SxDataSchreib2=0;                        // SxDaten die geschrieben werden  
  byte SxBelegData[28];                         // ausgelesenes Byte [j]
  byte OldSxBelegData[28];                      // altes Byte [j]
  
void sxisr(void) 
    { 
    SXbus.isr();
    }

void setup() 
    {
    // Serial.begin(115200);
    analogWrite(5, 50);                             // Hintergrunbeleuchtung steuern 
    SXbus.init();                                   // SX-bus Kommunikation
    attachInterrupt(0, sxisr, RISING);              // wechsel INT0 triggers the interrupt routine sxisr (see above)
    tft.begin();                                    // tft starten      
    
    tft.fillScreen(ILI9341_BLUE);                   // Bildschirm färben
    tft.setRotation(1);                             // Bildschirmausrichtung
    tft.setCursor(20,40);
    tft.setTextSize(2);                             // Textgröße
    // Serial.println("Initializing SD card...");
    if (!SD.begin(7))                               // 4 bzw 7 = Pin ChipSelect
        {
        // Serial.println("initialization failed!");
        tft.print(F("SD-Karte fehlgeschlagen"));
        while (1);
        }     
    tft.print(F("SD-Karte ok"));
    tft.setCursor(20,70);
    if (! ts.begin()) 
        {
        tft.print(F("Touch nicht gefunden"));
        while(1);
        }
    tft.print(F("Touch ok"));
    delay(2000);
    
    tft.fillScreen(ILI9341_BLUE);                   // Bildschirm färben 
    tft.setTextSize(3);                             // Textgröße
    tft.setTextColor(ILI9341_GREEN);                // Schriftfarbe grün
    tft.setCursor(80,50);
    tft.print(F("Selectrix"));
    tft.setTextSize(3);                             // 
    // tft.setTextColor(ILI9341_YELLOW);
    tft.setCursor(10,100);
    tft.print(F("Zugnummernanzeige"));
    tft.setTextSize(3);                             // 
    tft.setTextColor(ILI9341_YELLOW);
    tft.setCursor(120,150);
    tft.print(F("V34"));   
    delay(3000);                                    // warte
    tft.fillScreen(ILI9341_BLUE);                   // Bildschirm färben
    tft.setTextColor(ILI9341_WHITE,ILI9341_BLUE);
    for (int i=1; i <= Felder_Y; i++)
        {
        tft.fillRect(0, Display_Y/Felder_Y*i-Abstand_Y, Display_X, Abstand_Y, ILI9341_BLACK);
        }
    for (int i=1; i <= Felder_X; i++)
        {
        tft.drawLine(Display_X/Felder_X*i , 0 , Display_X/Felder_X*i  , Display_Y,  ILI9341_BLACK);
        }
    }

void loop() 
    {
    j=21;                                           // Zähler für Schleife
    for (i=51; i < 75; i++)                         // Schleife für Schattenbhf    
        {
        if (i == 59 || i == 69)                     // diese Adressen überspringen
            {
            i++;                                    // Schleife erhöhen
            }
        if (i == 60 || i == 70)                     // diese Adressen überspringen
            {
            i++;                                    // Schleife erhöhen
            }
        j--;                                        // Position runter zählen
        SxBelegData[j]=SXbus.read(i);               // Sx-Adresse auslesen              
        if (OldSxBelegData[j] != SxBelegData[j])    // überprüfen ob sich etwas geändert hat           
            {                                       // Daten haben sich auf dem Bus geändert ?
            OldSxBelegData[j] = SxBelegData[j];     // aktueller Wert wird zu altem Wert 
            pos = j-1;                              // Bildschirm Feld
            byte lok = OldSxBelegData[j];           // Loknummer
            myStrLok = String(lok);                 // in string umwandeln  
            if (myStrLok == "0")                    // wenn der Belegtmelder frei wird           
                {
                LokAdr[1] = "--";                   // Adresse löschen
                Gattung[1] = "-";                   // Gattung löschen
                Baureihe[1] = "---";                // Baureihe löschen
                drawFrame();
                }
            else
                {
                readFile();                         // Sprung Unterprogramm
                }              
            }
        }  

    if (!ts.bufferEmpty())
        {   
        TS_Point p = ts.getPoint();                     // Touch gedrückt
        // Scale using the calibration #'s and rotate coordinate system
        p.x = map(p.x, TS_MINY, TS_MAXY, 0, tft.height());
        p.y = map(p.y, TS_MINX, TS_MAXX, 0, tft.width());
        int pos_y = tft.height() - p.x;                 // Koordinaten berechnen
        int pos_x = p.y;                                // Koordinaten berechnen
        // Serial.print("X = "); Serial.print(pos_x);
        // Serial.print("\tY = "); Serial.println(pos_y);
        // x = 4, 84, 164, 244
        // y = 0, 48, 96, 144, 192  
        if (pos_y > 192 && pos_y < 239)
            {
            if (pos_x >   1 && pos_x <  80)             // Taste 1
                {
                SxAdrSchreib1=6;SxDataSchreib1=1;
                SxAdrSchreib2=9;SxDataSchreib2=1;
                Schreiben();
                }
            if (pos_x >  84 && pos_x < 160)             // Taste 2
                {
                SxAdrSchreib1=6;SxDataSchreib1=2;
                SxAdrSchreib2=9;SxDataSchreib2=1;  
                Schreiben();
                }
            if (pos_x > 164 && pos_x < 240)             // Taste 3
                {
                SxAdrSchreib1=6;SxDataSchreib1=4;
                SxAdrSchreib2=9;SxDataSchreib2=1;
                Schreiben();
                }
            if (pos_x > 244 && pos_x < 319)             // Taste 4
                {
                SxAdrSchreib1=6;SxDataSchreib1=8;
                SxAdrSchreib2=9;SxDataSchreib2=1;
                Schreiben();
                }
            }   
        if (pos_y > 144 && pos_y < 188)
            {
            if (pos_x >   1 && pos_x <  80)             // Taste 5
                {
                SxAdrSchreib1=6;SxDataSchreib1=16;
                SxAdrSchreib2=9;SxDataSchreib2=2;
                Schreiben();
                }
            if (pos_x >  84 && pos_x < 160)             // Taste 6
                {
                SxAdrSchreib1=6;SxDataSchreib1=32;
                SxAdrSchreib2=9;SxDataSchreib2=2; 
                (50);       
                Schreiben();
                }
            if (pos_x > 164 && pos_x < 240)             // Taste 7
                {
                SxAdrSchreib1=6;SxDataSchreib1=64;
                SxAdrSchreib2=9;SxDataSchreib2=2;
                Schreiben();
                }
            if (pos_x > 244 && pos_x < 319)             // Taste 8
                {
                SxAdrSchreib1=6;SxDataSchreib1=128;
                SxAdrSchreib2=9;SxDataSchreib2=2;
                Schreiben();
                }
            }
        if (pos_y > 96 && pos_y < 140)
            {
            if (pos_x >   1 && pos_x <  80)             // Taste 9
                {
                SxAdrSchreib1=7;SxDataSchreib1=1;
                SxAdrSchreib2=9;SxDataSchreib2=4;
                Schreiben();
                }
            if (pos_x >  84 && pos_x < 160)              // Taste 10
                {
                SxAdrSchreib1=7;SxDataSchreib1=2;
                SxAdrSchreib2=9;SxDataSchreib2=4; 
                Schreiben();
                }
            if (pos_x > 164 && pos_x < 240)             // Taste 11
                {
                SxAdrSchreib1=7;SxDataSchreib1=4;
                SxAdrSchreib2=9;SxDataSchreib2=4;
                Schreiben();
                }
            if (pos_x > 244 && pos_x < 319)             // Taste 12
                {
                SxAdrSchreib1=7;SxDataSchreib1=8;
                SxAdrSchreib2=9;SxDataSchreib2=4;
                Schreiben();
                }
            }
        if (pos_y > 48 && pos_y < 92)
            {
            if (pos_x >   1 && pos_x <  80)             // Taste 13
                {
                SxAdrSchreib1=7;SxDataSchreib1=16;
                SxAdrSchreib2=9;SxDataSchreib2=8;
                Schreiben();
                }
            if (pos_x >  84 && pos_x < 160)             // Taste 14
                {
                SxAdrSchreib1=7;SxDataSchreib1=32;
                SxAdrSchreib2=9;SxDataSchreib2=8;  
                Schreiben();
                }
            if (pos_x > 164 && pos_x < 240)             // Taste 15
                {
                SxAdrSchreib1=7;SxDataSchreib1=64;
                SxAdrSchreib2=9;SxDataSchreib2=8;
                Schreiben();
                }
            if (pos_x > 244 && pos_x < 319)             // Taste 16
                {
                SxAdrSchreib1=7;SxDataSchreib1=128;
                SxAdrSchreib2=9;SxDataSchreib2=8;
                Schreiben();
                }
            }      
        if (pos_y > 0 && pos_y < 44)
            {
            if (pos_x >   1 && pos_x <  80)             // Taste 17
                {
                SxAdrSchreib1=8;SxDataSchreib1=1;
                SxAdrSchreib2=9;SxDataSchreib2=16;
                Schreiben();
                }
            if (pos_x >  84 && pos_x < 160)             // Taste 18
                {
                SxAdrSchreib1=8;SxDataSchreib1=2;
                SxAdrSchreib2=9;SxDataSchreib2=16; 
                Schreiben();
                }
            if (pos_x > 164 && pos_x < 240)             // Taste 19
                {
                SxAdrSchreib1=8;SxDataSchreib1=4;
                SxAdrSchreib2=9;SxDataSchreib2=16;
                Schreiben();
                }
            if (pos_x > 244 && pos_x < 319)             // Taste 20
                {
                SxAdrSchreib1=8;SxDataSchreib1=8;
                SxAdrSchreib2=9;SxDataSchreib2=16;
                Schreiben();
                }
            }     
        }   
    // Serial.println("huhu");
    }

void readFile()                                         // auslesen der Datei und Disply beschreiben
    {
    inData = "";                                        // Puffer löschen
    myFile = SD.open("Loks.txt");                       // open the file for reading:
    while (myFile.available()) 
        {       
        char recieved = myFile.read();                  // read from the file until there's nothing else in it:                                      // 
        inData += recieved;                             // empfangene Zechen dran hängen
        if (recieved == '\n')                           // wenn Zeile fertig
            {                                  
            Baureihe[1] = inData.substring(5, 12);      // Baureihe separieren
            // Serial.println(Baureihe[1]);
            Gattung[1]  = inData.substring(20, 21);     // Gattung separieren       
            // Serial.println(Gattung[1]);
            LokAdr[1] = inData.substring(26,28);        // Lokadresse separieren
            // Serial.println(LokAdr[1]);
            inData = "";                                // Puffer löschen  
            // Serial.println(inData);
            if (LokAdr[1] == myStrLok)                  // wenn Lok bekannt ist
                {
                break;                                  // Schleife abbrechen
                }
            }
        }
    myFile.close();                                     // Datei schließen 
    drawFrame();                                        // Sprung Unterprogramm 
    }

void drawFrame() 
    {
    byte zeile = pos/Felder_X;                          // berechnen der Zeile
    byte spalte = pos-zeile*Felder_X;                   // berechnen der Spalte  
    tft.fillRect(spalte*BlueField_W+spalte*Abstand_X+Abstand_X-2, zeile*BlueField_H+zeile*Abstand_Y, BlueField_W, BlueField_H, ILI9341_BLUE);    
    //                 *  76       +      *   4     +   4     ,      *     46    +     *    2    ,     76     ,     46     , 
    // x = 4, 84, 164, 244
    // y = 0, 48, 96, 144, 192
    tft.setTextSize(2);                                 // Lokadresse
    tft.setTextColor(ILI9341_WHITE);
    tft.setCursor(spalte*BlueField_W+spalte*Abstand_X+3,zeile*BlueField_H+zeile*Abstand_Y+4);
    tft.print(LokAdr[1]);
    tft.setTextSize(2);                                 // Gattung
    tft.setTextColor(ILI9341_GREEN);
    tft.setCursor(spalte*BlueField_W+spalte*Abstand_X+56,zeile*BlueField_H+zeile*Abstand_Y+4);          
    tft.println(Gattung[1]);            
    tft.setTextSize(2);                                 // Baureihe           
    tft.setTextColor(ILI9341_YELLOW);
    tft.setCursor(spalte*BlueField_W+spalte*Abstand_X+3,zeile*BlueField_H+zeile*Abstand_Y+25);          
    tft.println(Baureihe[1]);
    }

 void Schreiben()                                       // Sx-Bus beschreiben, Fahrstraße stellen
    {    
    /*tft.setCursor(10,10);
    tft.println(SxAdrSchreib1); 
    tft.setCursor(10,30);
    tft.println(SxDataSchreib1);                       
    tft.setCursor(10,60);
    tft.println(SxAdrSchreib2); 
    tft.setCursor(10,80);
    tft.println(SxDataSchreib2);                       
    delay(100);
    */
    SXbus.write(SxAdrSchreib1,SxDataSchreib1);          // Daten auf Sx-Bus schreiben
    delay(100);                                         // warte
    SXbus.write(SxAdrSchreib2,SxDataSchreib2);          // Daten auf Sx-Bus schreiben
    delay(100);                                         // warte
    SXbus.write(SxAdrSchreib1,0);                       // Daten auf Sx-Bus schreiben
    delay(100);                                         // warte
    SXbus.write(SxAdrSchreib2,0);                       // Daten auf Sx-Bus schreiben
    // delay(50);                                       // warte
    } 
