/*  
 *  SxNano_Signal_4fach_HV_pwm_V33.ino
 *
 *  Ansteuerung von 4x Hauptsignalen oder 2x Hauptsignale mit 2x Vorsignalen über PWM
 *  Für Led's mit gemeinsamer Anode (Plus) (zB Viessmann)
 *  Es werden nur 2 Bit pro Signal benötigt.
 *  Im Modus Hs/Vs wird nur eine "halbe" SxAdresse benötigt.
 *  Es können mit einer Sx-Adresse somit 4xHS mit 4xVS geschaltet werden.
 *
 *  Libraries: SXArduino: Quellen von G.v.d.Sel
 *  https://github.com/gvandersel/SXArduino
 *  Zielhardware mit Aufsteckplatine: Andreas Horn
 *                                    Frank Keil http://frank-keil.de/Selectrix/Sx-Decoder/Sx-Decoder.html
 *  Controller: Arduino NanoESP (5V, 16MHz), ATmega328
 *
 *  Created on: 02.01.2012
 *  Last changed on: 10.10.2020
 *  
 *  Author: fk
 *
 *  Pin2=T0=INT0, Pin4=T1, Pin3=SX-Write-High, Pin6=SX-Write-Low
 *
 *  Zum Programmieren des Moduls am SX-Bus werden die SX-Kanäle 0 bis 6 verwendet:
 *
 *   SX-Kanal 0 : Sx-Decoder-Adresse (0..99)
 *   SX-Kanal 1 : FadeZeit Aus (0..255)
 *   SX-Kanal 2 : FadeZeit An  (0..255)
 *   SX-Kanal 3 : Wartezeit bis LED wieder an geht(0..255)
 *   SX-Kanal 4 : Modus zur Konfigurierung
 *   xxxxxxx0   : (0) 2xVs/2xHs ; (1) 4xHs 
 *   xxxxxx0x   : (0) Vs1 am Mast ; (1) Vs1 separat
 *   xxxxx0xx   : (0) Vs2 am Mast ; (1) Vs2 separat
 *   xxxx0xxx   : (0) unteres Halbbyte ; (1) oberes Halbbyte (nur im Vs/Hs Modus)
 *   xx00xxxx   : Nr des zu VS1 zugehörigen Hauptsignals (1-4)
 *                00 -> 1 ; 01 -> 2 ; 10 -> 3 ; 11 -> 4
 *   00xxxxxx   : Nr des zu VS2 zugehörigen Hauptsignals (1-4)
 *                00 -> 1 ; 01 -> 2 ; 10 -> 3 ; 11 -> 4
 *   SX-Kanal 5 : Adr des zu VS1 zugehörigen Hauptsignals (0..99)
 *   SX-Kanal 6 : Adr des zu VS2 zugehörigen Hauptsignals (0..99)
 *  
 *  Pin10 Leuchtet wenn Prog-Freigabe schon belegt ist
 *  Pin11 ist während der Programmierung an
 * 
 */

  #include "SXArduino.h"                              // Lib einbinden
  SXArduino SXbus(2,4,6,3);                           // Pinbelegung (Takt, Daten, Schreiben, Schreiben)
  bool noCC2000 = false;                              // false 0 ... 103, true 0 ... 111

  #include <EEPROM.h>                                 // EEPROM Bibliothek hinzufügen

  #include <SoftPWM.h>                                // SoftPwm Bibliothek hinzufügen

  /*
  SOFTPWM_DEFINE_CHANNEL(0, DDRD, PORTD, PORTD0);     //Arduino pin 0
  SOFTPWM_DEFINE_CHANNEL(1, DDRD, PORTD, PORTD1);     //Arduino pin 1
  // SOFTPWM_DEFINE_CHANNEL(2, DDRD, PORTD, PORTD2);  //Arduino pin 2
  // SOFTPWM_DEFINE_CHANNEL(3, DDRD, PORTD, PORTD3);  //Arduino pin 3
  // SOFTPWM_DEFINE_CHANNEL(4, DDRD, PORTD, PORTD4);  //Arduino pin 4
  SOFTPWM_DEFINE_CHANNEL(5, DDRD, PORTD, PORTD5);     //Arduino pin 5
  // SOFTPWM_DEFINE_CHANNEL(6, DDRD, PORTD, PORTD6);  //Arduino pin 6
  SOFTPWM_DEFINE_CHANNEL(7, DDRD, PORTD, PORTD7);     //Arduino pin 7
  SOFTPWM_DEFINE_CHANNEL(8, DDRB, PORTB, PORTB0);     //Arduino pin 8
  SOFTPWM_DEFINE_CHANNEL(9, DDRB, PORTB, PORTB1);     //Arduino pin 9
  SOFTPWM_DEFINE_CHANNEL(10, DDRB, PORTB, PORTB2);    //Arduino pin 10
  SOFTPWM_DEFINE_CHANNEL(11, DDRB, PORTB, PORTB3);    //Arduino pin 11
  SOFTPWM_DEFINE_CHANNEL(12, DDRB, PORTB, PORTB4);    //Arduino pin 12
  SOFTPWM_DEFINE_CHANNEL(13, DDRB, PORTB, PORTB5);    //Arduino pin 13
  SOFTPWM_DEFINE_CHANNEL(14, DDRC, PORTC, PORTC0);    //Arduino pin A0
  SOFTPWM_DEFINE_CHANNEL(15, DDRC, PORTC, PORTC1);    //Arduino pin A1
  SOFTPWM_DEFINE_CHANNEL(16, DDRC, PORTC, PORTC2);    //Arduino pin A2
  SOFTPWM_DEFINE_CHANNEL(17, DDRC, PORTC, PORTC3);    //Arduino pin A3
  SOFTPWM_DEFINE_CHANNEL(18, DDRC, PORTC, PORTC4);    //Arduino pin A4
  SOFTPWM_DEFINE_CHANNEL(19, DDRC, PORTC, PORTC5);    //Arduino pin A5
  */
  
  SOFTPWM_DEFINE_CHANNEL_INVERT(0, DDRD, PORTD, PORTD0);  //Arduino pin 0
  SOFTPWM_DEFINE_CHANNEL_INVERT(1, DDRD, PORTD, PORTD1);  //Arduino pin 1
  // SOFTPWM_DEFINE_CHANNEL(2, DDRD, PORTD, PORTD2);      //Arduino pin 2
  // SOFTPWM_DEFINE_CHANNEL(3, DDRD, PORTD, PORTD3);      //Arduino pin 3
  // SOFTPWM_DEFINE_CHANNEL(4, DDRD, PORTD, PORTD4);      //Arduino pin 4
  SOFTPWM_DEFINE_CHANNEL_INVERT(5, DDRD, PORTD, PORTD5);  //Arduino pin 5
  // SOFTPWM_DEFINE_CHANNEL(6, DDRD, PORTD, PORTD6);      //Arduino pin 6
  SOFTPWM_DEFINE_CHANNEL_INVERT(7, DDRD, PORTD, PORTD7);  //Arduino pin 7
  SOFTPWM_DEFINE_CHANNEL_INVERT(8, DDRB, PORTB, PORTB0);  //Arduino pin 8
  SOFTPWM_DEFINE_CHANNEL_INVERT(9, DDRB, PORTB, PORTB1);  //Arduino pin 9
  SOFTPWM_DEFINE_CHANNEL_INVERT(10, DDRB, PORTB, PORTB2); //Arduino pin 10
  SOFTPWM_DEFINE_CHANNEL_INVERT(11, DDRB, PORTB, PORTB3); //Arduino pin 11
  SOFTPWM_DEFINE_CHANNEL_INVERT(12, DDRB, PORTB, PORTB4); //Arduino pin 12
  SOFTPWM_DEFINE_CHANNEL_INVERT(13, DDRB, PORTB, PORTB5); //Arduino pin 13
  SOFTPWM_DEFINE_CHANNEL_INVERT(14, DDRC, PORTC, PORTC0); //Arduino pin A0
  SOFTPWM_DEFINE_CHANNEL_INVERT(15, DDRC, PORTC, PORTC1); //Arduino pin A1
  SOFTPWM_DEFINE_CHANNEL_INVERT(16, DDRC, PORTC, PORTC2); //Arduino pin A2
  SOFTPWM_DEFINE_CHANNEL_INVERT(17, DDRC, PORTC, PORTC3); //Arduino pin A3
  SOFTPWM_DEFINE_CHANNEL_INVERT(18, DDRC, PORTC, PORTC4); //Arduino pin A4
  SOFTPWM_DEFINE_CHANNEL_INVERT(19, DDRC, PORTC, PORTC5); //Arduino pin A5
 
  SOFTPWM_DEFINE_OBJECT(20);
  
  // Led Zuordnung FK
  #define Sig1_1  1                           // Hs1 rt
  #define Sig1_2  0                           // Hs1 gn
  #define Sig1_3  5                           // Hs1 ge
  #define Sig1_4  7                           // Hs1 ws
  #define Sig2_1  8                           // Hs2 rt
  #define Sig2_2  9                           // Hs2 gn
  #define Sig2_3 10                           // Hs2 ge
  #define Sig2_4 11                           // Hs2 ws
  #define Sig3_1 12                           // Hs3 rt / Vs3 ge
  #define Sig3_2 13                           // Hs3 gn / Vs3 ge
  #define Sig3_3 14                           // Hs3 ge / Vs3 gn
  #define Sig3_4 15                           // Hs3 ws / Vs3 gn
  #define Sig4_1 16                           // Hs4 rt / Vs4 ge
  #define Sig4_2 17                           // Hs4 gn / Vs4 ge
  #define Sig4_3 18                           // Hs4 ge / Vs4 gn
  #define Sig4_4 19                           // Hs4 ws / Vs4 gn
  
  /*                                          // Led Zuordnung Andreas Horn
  #define Sig1_1  7                           // Hs1 rt
  #define Sig1_2  9                           // Hs1 gn
  #define Sig1_3 11                           // Hs1 ge
  #define Sig1_4 14                           // Hs1 ws
  #define Sig2_1 16                           // Hs2 rt
  #define Sig2_2 18                           // Hs2 gn
  #define Sig2_3  1                           // Hs2 ge
  #define Sig2_4 13                           // Hs2 ws
  #define Sig3_1  5                           // Hs3 rt / Vs3 ge
  #define Sig3_2  8                           // Hs3 gn / Vs3 ge
  #define Sig3_3 10                           // Hs3 ge / Vs3 gn
  #define Sig3_4 12                           // Hs3 ws / Vs3 gn
  #define Sig4_1 15                           // Hs4 rt / Vs4 ge
  #define Sig4_2 17                           // Hs4 gn / Vs4 ge
  #define Sig4_3  0                           // Hs4 ge / Vs4 gn
  #define Sig4_4 19                           // Hs4 ws / Vs4 gn
  */
  
  int analogPin = 6;                          // Progtaster
  byte DecAdr=10;                             // Decoder Adresse
  byte VS1Adr=11;                             // Adresse des zum Vs1 zugehörige Hs
  byte VS2Adr=11;                             // Adresse des zum Vs2 zugehörige Hs
  byte VS1nr=3;                               // welches Hs der Adresse (1=3,2=12,3=48,4=192)
  byte VS2nr=12;                              // welches Hs der Adresse (1=3,2=12,3=48,4=192)
  byte SxAdr1;                                // 1. Sx Adresse
  byte SxData1;                               // aktuelles Byte
  byte SxData2;                               // aktuelles Byte
  byte SxData3;                               // aktuelles Byte
  byte Vergleich=0;                           // Progbit (Adr106)
  byte oldSxData1;                            // 1. altes Byte
  byte SxAdrSchreib=0;                        // SxAdressen die geschrieben werden 
  byte SxDataSchreib=0;                       // SxDaten die geschrieben werden 
  byte tb;                                    // Gleisbit
  byte oldtb;                                 // alter Wert Gleisbit
  int progAkt;                                // Programmierung aktiv
  int Prog = 0;                               // Analogwert Progtaster
  byte i;                                     // Zählvariable
  byte wertAus;                               // Wartezeit Aus
  byte wertAn;                                // Wartezeit An
  byte wertWarte;                             // Auszeit
  int Sig1;                                   // Wert Sig1
  byte d_l1;                                  // Hilfsvariable Sig1
  int Sig2;                                   // Wert Sig2
  byte d_h1;                                  // Hilfsvariable Sig2
  int Sig3;                                   // Wert Sig3    
  int Sig4;                                   // Wert Sig4
  int oldSig1;                                // alter Wert Sig1
  int oldSig2;                                // altes Wert Sig2
  int oldSig3;                                // altes Wert Sig3
  int oldSig4;                                // altes Wert Sig4
  byte Modus;                                 // Decodermodus
  byte sigMast1;                              // Vorsignal 1 am Mast
  byte sigMast2;                              // Vorsignal 2 am Mast
  byte sigMod;                                // H/H H/V
  byte halbByte;                              // oberes oder unteres Halbbyte
  byte VS1;                                   // Wert Vorsignal 1
  byte VS2;                                   // Wert Vorsignal 2
  byte oldVS1;                                // alter Wert Vorsignal 1
  byte oldVS2;                                // alter Wert Vorsignal 2
  unsigned long nextMicros;                   // Zeit seit dem Einschalten
  
void sxisr(void)                              // Unterprogramm
      {
      SXbus.isr();
      }

void setup() 
    {
    // Serial.begin(115200);                  // Schnittstelle mit Baudrate aktivieren
    SXbus.init();                             // SX-bus Kommunikation
    attachInterrupt(0, sxisr, RISING);        // wechsel INT0 triggers the interrupt routine sxisr (see above)
    DecAdr = EEPROM.read(1);                  // EEprom Zelle 1 auslesen
    wertAus = EEPROM.read(2);                 // EEprom Zelle 2 auslesen
    wertAn = EEPROM.read(3);                  // EEprom Zelle 3 auslesen
    wertWarte = EEPROM.read(4);               // EEprom Zelle 4 auslesen
    Modus = EEPROM.read(5);                   // EEprom Zelle 5 auslesen         
    VS1Adr= EEPROM.read(6);                   // EEprom Zelle 6 auslesen
    VS2Adr = EEPROM.read(7);                  // EEprom Zelle 7 auslesen
    Palatis::SoftPWM.begin(60);               // begin with 60Hz pwm frequency      
    Grundstellung();                          // springe zum Unterprogramm
    }

void loop() 
    {
    SxData1=SXbus.read(DecAdr);                           // überprüfen ob sich etwas geändert hat
    if (sigMod == true)                                   // sigMod = 1 dann 4 Hauptsignale
        {                                                 // wenn 0 dann mit Vorsignal
        Sig1 = SxData1 & B00000011;                       // Signal 1 (Hauptsignal)      
        Sig2 = SxData1 & B00001100;                       // Signal 2 (Hauptsignal)
        Sig3 = SxData1 & B00110000;                       // Signal 3 (Hauptsignal)
        Sig4 = SxData1 & B11000000;                       // Signal 4 (Hauptsignal)

        // ************************************************* Sig1    
        if (oldSig1 != Sig1)                              // Daten haben sich auf dem Bus geändert?
            {                                         
            // ********************************************* Lampen ausschalten
            nextMicros = 0;      
            for (int v = 255; v >= 0 ; --v) 
                {
                while (micros() < nextMicros);
                nextMicros = micros() + wertAus*20;
                if (oldSig1 == 0 || oldSig1 == 2) Palatis::SoftPWM.set(Sig1_1, v);  // Hp0
                if (oldSig1 == 1 || oldSig1 == 3) Palatis::SoftPWM.set(Sig1_2, v);  // Hp1
                if (oldSig1 == 3)                 Palatis::SoftPWM.set(Sig1_3, v);  // Hp2
                if (oldSig1 == 2)                 Palatis::SoftPWM.set(Sig1_4, v);  // Sh0
                }
            delay(wertWarte*2);
            // ********************************************* Lampen einschalten          
            if (Sig1 == 0)                                // Signal Hp0
                {
                nextMicros = 0;             
                for (int v = 0; v < 256 ; ++v) 
                    {
                    while (micros() < nextMicros);
                    nextMicros = micros() + wertAn*20;
                    Palatis::SoftPWM.set(Sig1_1, v);      // HS rt
                    }
                }   
            if (Sig1 == 1)                                // Signal Hp1
                {
                nextMicros = 0;             
                for (int v = 0; v < 256 ; ++v) 
                    {
                    while (micros() < nextMicros);
                    nextMicros = micros() + wertAn*20;
                    Palatis::SoftPWM.set(Sig1_2, v);      // HS gn
                    }
                }
            if (Sig1 == 3)                                // Signal Hp2
                {
                nextMicros = 0;             
                for (int v = 0; v < 256 ; ++v) 
                    {
                    while (micros() < nextMicros);
                    nextMicros = micros() + wertAn*20;
                    Palatis::SoftPWM.set(Sig1_2, v);      // HS gn
                    Palatis::SoftPWM.set(Sig1_3, v);      // HS ge
                    }
                }
            if (Sig1 == 2)                                // Signal Sh1
                {
                nextMicros = 0;             
                for (int v = 0; v < 256 ; ++v) 
                    {
                    while (micros() < nextMicros);
                    nextMicros = micros() + wertAn*20;
                    Palatis::SoftPWM.set(Sig1_1, v);      // HS rt
                    Palatis::SoftPWM.set(Sig1_4, v);      // HS ws
                    }
                }                        
            oldSig1 = Sig1;                               // aktueller Wert wird zu altem Wert
            }                     
        // ************************************************* Sig2         
        if (oldSig2 != Sig2)                              // Daten Sig2 geändert? 
            {    
            // ********************************************* Lampen ausschalten
            nextMicros = 0;                               // alle Lampen aus       
            for (int v = 255; v >= 0 ; --v) 
                {
                while (micros() < nextMicros);
                nextMicros = micros() + wertAus*20;
                if (oldSig2 == 0 || oldSig2 == 8)   Palatis::SoftPWM.set(Sig2_1, v);  // Hp0
                if (oldSig2 == 4 || oldSig2 == 12)  Palatis::SoftPWM.set(Sig2_2, v);  // Hp1
                if (oldSig2 == 12)                  Palatis::SoftPWM.set(Sig2_3, v);  // Hp2       
                if (oldSig2 == 8)                   Palatis::SoftPWM.set(Sig2_4, v);  // Sh1
                }
            delay(wertWarte*2);
            // ********************************************* Lampen einschalten          
            if (Sig2 == 0)                                // Signal 2 Hp0
                {
                nextMicros = 0;             
                for (int v = 0; v < 256 ; ++v) 
                    {
                    while (micros() < nextMicros);
                    nextMicros = micros() + wertAn*20;
                    Palatis::SoftPWM.set(Sig2_1, v);      // Hs2 rt
                    }
                }   
            if (Sig2 == 4)                                // Signal 2 Hp1
                {
                nextMicros = 0;             
                for (int v = 0; v < 256 ; ++v) 
                    {
                    while (micros() < nextMicros);
                    nextMicros = micros() + wertAn*20;
                    Palatis::SoftPWM.set(Sig2_2, v);      // Hs2 gn
                    }
                }
            if (Sig2 == 12)                               // Signal 2 Hp2
                {
                nextMicros = 0;             
                for (int v = 0; v < 256 ; ++v) 
                    {
                    while (micros() < nextMicros);
                    nextMicros = micros() + wertAn*20;
                    Palatis::SoftPWM.set(Sig2_2, v);      // Hs2 gn
                    Palatis::SoftPWM.set(Sig2_3, v);      // Hs2 ge
                    }
                }
            if (Sig2 == 8)                                // Signal 2 Sh1
                {
                nextMicros = 0;             
                for (int v = 0; v < 256 ; ++v) 
                    {
                    while (micros() < nextMicros);
                    nextMicros = micros() + wertAn*20;
                    Palatis::SoftPWM.set(Sig2_1, v);      // Hs2 rt
                    Palatis::SoftPWM.set(Sig2_4, v);      // Hs2 ws
                    }
                }                        
            oldSig2 = Sig2;                               // aktueller Wert wird zu altem Wert
            }
        // ************************************************* Sig3     
        if (oldSig3 != Sig3)                              // Daten haben sich auf dem Bus geändert?   
            {                                         
            // ********************************************* Lampen ausschalten
            nextMicros = 0;                               // alle Lampen aus       
            for (int v = 255; v >= 0 ; --v) 
                {
                while (micros() < nextMicros);
                nextMicros = micros() + wertAus*20;
                if (oldSig3 == 0 || oldSig3 == 32)    Palatis::SoftPWM.set(Sig3_1, v);  // Hp0
                if (oldSig3 == 16 || oldSig3 == 48)   Palatis::SoftPWM.set(Sig3_2, v);  // Hp1
                if (oldSig3 == 48)                    Palatis::SoftPWM.set(Sig3_3, v);  // Hp2
                if (oldSig3 == 32)                    Palatis::SoftPWM.set(Sig3_4, v);  // Sh1
                }
            delay(wertWarte*2);
            // ************************************************* Lampen einschalten          
            if (Sig3 == 0)                                // Signal 3 Hp0
                {
                nextMicros = 0;             
                for (int v = 0; v < 256 ; ++v) 
                    {
                    while (micros() < nextMicros);
                    nextMicros = micros() + wertAn*20;
                    Palatis::SoftPWM.set(Sig3_1, v);      // Hs3 rt
                    }
                }   
            if (Sig3 == 16)                               // Signal 3 Hp1
                {
                nextMicros = 0;             
                for (int v = 0; v < 256 ; ++v) 
                    {
                    while (micros() < nextMicros);
                    nextMicros = micros() + wertAn*20;
                    Palatis::SoftPWM.set(Sig3_2, v);      // Hs3 gn
                    }                                   
                }
            if (Sig3 == 48)                               // Signal 3 Hp2
                {
                nextMicros = 0;             
                for (int v = 0; v < 256 ; ++v) 
                    {
                    while (micros() < nextMicros);
                    nextMicros = micros() + wertAn*20;
                    Palatis::SoftPWM.set(Sig3_2, v);      // Hs3 gn
                    Palatis::SoftPWM.set(Sig3_3, v);      // Hs3 ge
                    }
                }
            if (Sig3 == 32)                               // Signal 3 Sh1
                {
                nextMicros = 0;             
                for (int v = 0; v < 256 ; ++v) 
                    {
                    while (micros() < nextMicros);
                    nextMicros = micros() + wertAn*20;
                    Palatis::SoftPWM.set(Sig3_1, v);      // Hs3 rt
                    Palatis::SoftPWM.set(Sig3_4, v);      // Hs3 ws
                    }
                }                        
            oldSig3 = Sig3;                               // aktueller Wert wird zu altem Wert
            }
        // ************************************************* Sig4     
        if (oldSig4 != Sig4)                              // Daten haben sich auf dem Bus geändert?
            {                                   
            // ************************************************* Lampen ausschalten
            nextMicros = 0;                               // alle Lampen aus       
            for (int v = 255; v >= 0 ; --v) 
                {
                while (micros() < nextMicros);
                nextMicros = micros() + wertAus*20;
                if (oldSig4 == 0 || oldSig4 == 128)   Palatis::SoftPWM.set(Sig4_1, v);  // Hp0
                if (oldSig4 == 64 || oldSig4 == 192)  Palatis::SoftPWM.set(Sig4_2, v);  // Hp1
                if (oldSig4 == 192)                   Palatis::SoftPWM.set(Sig4_3, v);  // Hp2
                if (oldSig4 == 128)                   Palatis::SoftPWM.set(Sig4_4, v);  // Sh1
                }
            delay(wertWarte*2);
            // ************************************************* Lampen einschalten          
            if (Sig4 == 0)                                // Signal 4 Hp0
                {
                nextMicros = 0;             
                for (int v = 0; v < 256 ; ++v) 
                    {
                    while (micros() < nextMicros);
                    nextMicros = micros() + wertAn*20;
                    Palatis::SoftPWM.set(Sig4_1, v);      // Hs4 rt
                    }
                }   
            if (Sig4 == 64)                               // Signal 4 Hp1
                {
                nextMicros = 0;             
                for (int v = 0; v < 256 ; ++v) 
                    {
                    while (micros() < nextMicros);
                    nextMicros = micros() + wertAn*20;
                    Palatis::SoftPWM.set(Sig4_2, v);      // Hs4 gn
                    }
                }
            if (Sig4 == 192)                              // Signal 4 Hp2
                {
                nextMicros = 0;             
                for (int v = 0; v < 256 ; ++v) 
                    {
                    while (micros() < nextMicros);
                    nextMicros = micros() + wertAn*20;
                    Palatis::SoftPWM.set(Sig4_2, v);      // Hs4 gn
                    Palatis::SoftPWM.set(Sig4_3, v);      // Hs4 ge
                    }
                }
            if (Sig4 == 128)                              // Signal 4 Sh1
                {
                nextMicros = 0;             
                for (int v = 0; v < 256 ; ++v) 
                    {
                    while (micros() < nextMicros);
                    nextMicros = micros() + wertAn*20;
                    Palatis::SoftPWM.set(Sig4_1, v);      // Hs4 rt
                    Palatis::SoftPWM.set(Sig4_4, v);      // Hs4 ws
                    }
                }                        
            }
        oldSig4 = Sig4;                                   // aktueller Wert wird zu altem Wert
        }

    // ***************************************************** Signal 1 mit Vorsignal              
    if (sigMod == 0)                                      // sigMod = 0 dann mit Vorsignale
        {
        if (halbByte == 8)                                // wenn = 8 oberes Halb-Byte
            {                                             // oberes HalbByte
            d_h1 = SxData1 & B11000000;                   // Signal 4 (Hauptsignal)
            d_l1 = SxData1 & B00110000;                   // Signal 3 (Hauptsignal)
            Sig2 = d_h1 >> 4;                             // Signal 2 (Hauptsignal)
            Sig1 = d_l1 >> 4;                             // Signal 1 (Hauptsignal)
            }
         else                                             // unteres HalbByte
            {
            Sig2 = SxData1 & B00001100;                   // Signal 2 (Hauptsignal)
            Sig1 = SxData1 & B00000011;                   // Signal 1 (Hauptsignal)
            }   
        // ************************************************* Sig1       
        if (oldSig1 != Sig1)                              // Daten haben sich auf dem Bus geändert?
            {                                         
            if (oldSig1 == 0 && (Sig1 == 1 || Sig1 == 3)) // wenn es Hp0 war und Hp1 oder Hp2 wird
                {
                // Serial.println("491, VS/HS, Sig1, Hp0 -> Hp1 o Hp2 ");  // Ausgabe
                if (sigMast1 == false)                    // wenn Vorsignal am Mast
                    {
                    nextMicros = 0;                       // Vorsignal an       
                    for (int v = 0; v < 256 ; ++v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAn*20;
                        Palatis::SoftPWM.set(Sig3_1, v);  // Vs3 ge1
                        Palatis::SoftPWM.set(Sig3_2, v);  // Vs3 ge2
                        }
                    oldVS1=0;                             // setze Vorsignal auf ge/ge
                    nextMicros = 0;                       // Lampen aus       
                    for (int v = 255; v >= 0 ; --v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAus*20;
                        Palatis::SoftPWM.set(Sig1_1, v);  // Hs1 rot aus
                        }
                    }
                else                                      // wenn Vorsignal separat
                    {
                    nextMicros = 0;                       // Lampen aus       
                    for (int v = 255; v >= 0 ; --v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAus*20;
                        Palatis::SoftPWM.set(Sig1_1, v);  // Hs1 rot
                        Palatis::SoftPWM.set(Sig3_1, v);  // Vs3 ge1
                        Palatis::SoftPWM.set(Sig3_2, v);  // Vs3 ge2
                        }
                    }
                }
            if (oldSig1 == 0 && Sig1 == 2)                // wenn es Hp0 war und Sh1 wird
                {
                // Serial.println("526, VS/HS, Sig1, Hp0 -> Sh1 ");  // Ausgabe
                if (sigMast1 == false)                    // wenn Vorsignal am Mast
                    {
                    nextMicros = 0;                       // Lampen aus       
                    for (int v = 255; v >= 0 ; --v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAus*20;
                        Palatis::SoftPWM.set(Sig1_1, v);  // Hs1 rot
                        }
                    }
                else                                      // wenn Vorsignal separat
                    {
                    nextMicros = 0;                       // Lampen aus       
                    for (int v = 255; v >= 0 ; --v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAus*20;
                        Palatis::SoftPWM.set(Sig1_1, v);  // Hs1 rt
                        }
                    }
                } 
            if (oldSig1 == 1)                             // wenn es Hp1 war
                {
                // Serial.println("550, VS/HS, Sig1, Hp1 -> ");  // Ausgabe
                if (sigMast1 == false)                    // wenn Vorsignal am Mast
                    {
                    // Serial.print("Hier.1..: ");        // Ausgabe
                    if (Sig1 == 0 || Sig1 == 2)           // wenn es Hp0/Sh0 wird
                        {
                        if (oldVS1 == 1)                  // wenn Vs gn war
                            {
                            nextMicros = 0;               // Lampen aus       
                            for (int v = 255; v >= 0 ; --v) 
                                {
                                while (micros() < nextMicros);
                                nextMicros = micros() + wertAus*20;
                                Palatis::SoftPWM.set(Sig3_3, v);  // Vs3 gn1
                                Palatis::SoftPWM.set(Sig3_4, v);  // Vs3 gn2
                                }
                            }
                        if (oldVS1 == 3)                          // wenn Vs gn/ge war
                            {
                            nextMicros = 0;                       // Lampen aus       
                            for (int v = 255; v >= 0 ; --v) 
                                {
                                while (micros() < nextMicros);
                                nextMicros = micros() + wertAus*20;
                                Palatis::SoftPWM.set(Sig3_2, v);  // Vs3 ge2
                                Palatis::SoftPWM.set(Sig3_3, v);  // Vs3 gn1
                                }
                            }
                        if (oldVS1 != 0 )                         // wenn Vs 
                            {
                            // Serial.print("oldVS1...: ");       // Ausgabe
                            // Serial.println(oldVS1);            // Ausgabe
                            delay(wertWarte*2);
                            nextMicros = 0;                       // Vorsignal an       
                            for (int v = 0; v < 256 ; ++v) 
                                {
                                while (micros() < nextMicros);
                                nextMicros = micros() + wertAn*20;
                                Palatis::SoftPWM.set(Sig3_1, v);  // Vs3 ge1
                                Palatis::SoftPWM.set(Sig3_2, v);  // Vs3 ge2
                                }
                            }
                        }
                    nextMicros = 0;                       // Lampen aus       
                    for (int v = 255; v >= 0 ; --v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAus*20;
                        Palatis::SoftPWM.set(Sig1_2, v);  // Hs1 gn
                        }
                    }
                else                                      // wenn Vorsignal separat
                    {
                    nextMicros = 0;                       // Lampen aus       
                    for (int v = 255; v >= 0 ; --v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAus*20;
                        Palatis::SoftPWM.set(Sig1_2, v);  // Hs1 gn
                        Palatis::SoftPWM.set(Sig3_3, v);  // Vs3 gn1
                        Palatis::SoftPWM.set(Sig3_4, v);  // Vs3 gn2
                        }
                    }
                }
            if (oldSig1 == 3 )                            // wenn es Hp2 war
                {
                // Serial.println("599, VS/HS, Sig1, Hp2 -> ");  // Ausgabe
                if (sigMast1 == false)                    // wenn Vorsignal am Mast
                    {
                    // Serial.print("Hier.2..: ");        // Ausgabe
                    if (Sig1 == 0 || Sig1 == 2)           // wenn es Hp0/Sh0 wird
                        {
                        if (oldVS1 == 1)                  // wenn Vs gn war
                            {
                            nextMicros = 0;               // Lampen aus       
                            for (int v = 255; v >= 0 ; --v) 
                                {
                                while (micros() < nextMicros);
                                nextMicros = micros() + wertAus*20;
                                Palatis::SoftPWM.set(Sig3_3, v);  // Vs3 gn1
                                Palatis::SoftPWM.set(Sig3_4, v);  // Vs3 gn2
                                }
                            }
                        if (oldVS1 == 3)                  // wenn Vs gn/ge war
                            {
                            nextMicros = 0;               // Lampen aus       
                            for (int v = 255; v >= 0 ; --v) 
                                {
                                while (micros() < nextMicros);
                                nextMicros = micros() + wertAus*20;
                                Palatis::SoftPWM.set(Sig3_2, v);  // Vs3 ge2
                                Palatis::SoftPWM.set(Sig3_3, v);  // Vs3 gn1
                                }
                            }
                        if (oldVS1 != 0 )                         // wenn Vs gn/ge war
                            {
                            // Serial.print("oldVS1...: ");       // Ausgabe
                            // Serial.println(oldVS1);            // Ausgabe
                            delay(wertWarte*2);
                            nextMicros = 0;                       // Vorsignal an       
                            for (int v = 0; v < 256 ; ++v) 
                                {
                                while (micros() < nextMicros);
                                nextMicros = micros() + wertAn*20;
                                Palatis::SoftPWM.set(Sig3_1, v);  // Vs3 ge1
                                Palatis::SoftPWM.set(Sig3_2, v);  // Vs3 ge2
                                }
                            }
                        }
                    nextMicros = 0;                       // Lampen aus       
                    for (int v = 255; v >= 0 ; --v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAus*20;
                        Palatis::SoftPWM.set(Sig1_2, v);  // Hs1 gn
                        Palatis::SoftPWM.set(Sig1_3, v);  // Hs1 ge
                        }
                    }
                else                                      // wenn Vorsignal separat
                    {
                    nextMicros = 0;                       // Lampen aus       
                    for (int v = 255; v >= 0 ; --v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAus*20;
                        Palatis::SoftPWM.set(Sig1_2, v);  // Hs1 gn
                        Palatis::SoftPWM.set(Sig1_3, v);  // Hs1 ge
                        Palatis::SoftPWM.set(Sig3_2, v);  // Vs3 ge2
                        Palatis::SoftPWM.set(Sig3_3, v);  // Vs3 gn1
                        }
                    }
                }              
            if (oldSig1 == 2 && (Sig1 == 1 || Sig1 == 3)) // wenn es Sh1 war und Hp1/Hp2 wird
                {
                // Serial.println("666, VS/HS, Sig1, Sh1 -> Hp1 o Hp2 ");  // Ausgabe
                if (sigMast1 == false)                    // wenn Vorsignal am Mast
                    {
                    nextMicros = 0;                       // Vorsignal an       
                    for (int v = 0; v < 256 ; ++v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAn*20;
                        Palatis::SoftPWM.set(Sig3_1, v);  // Vs3 ge1
                        Palatis::SoftPWM.set(Sig3_2, v);  // Vs3 ge2
                        }
                    // delay(wertWarte*2);
                    oldVS1=0;                             // setze Vorsignal auf ge/ge
                    nextMicros = 0;                       // Lampen aus       
                    for (int v = 255; v >= 0 ; --v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAus*20;
                        Palatis::SoftPWM.set(Sig1_1, v);  // HS1 rot
                        Palatis::SoftPWM.set(Sig1_4, v);  // HS1 ws
                        }
                    }
                else                                      // wenn Vorsignal separat
                    {
                    nextMicros = 0;                       // Lampen aus       
                    for (int v = 255; v >= 0 ; --v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAus*20;
                        Palatis::SoftPWM.set(Sig1_1, v);  // Hs1 rot
                        Palatis::SoftPWM.set(Sig1_4, v);  // Hs1 ws
                        Palatis::SoftPWM.set(Sig3_1, v);  // Vs3 ge1
                        Palatis::SoftPWM.set(Sig3_2, v);  // Vs3 ge2
                        }
                    }
                } 
            if (oldSig1 == 2 && Sig1 == 0)                // wenn es Sh1 war und Hp0 wird
                {
                // Serial.println("704, VS/HS, Sig1, Sh1 -> Hp0");  // Ausgabe
                if (sigMast1 == false)                    // wenn Vorsignal am Mast
                    {
                    nextMicros = 0;                       // Lampen aus       
                    for (int v = 255; v >= 0 ; --v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAus*20;
                        Palatis::SoftPWM.set(Sig1_1, v);  // Hs1 rt
                        Palatis::SoftPWM.set(Sig1_4, v);  // Hs1 ws
                        }
                    }
                else                                      // wenn Vorsignal separat
                    {
                    nextMicros = 0;                       // Lampen aus       
                    for (int v = 255; v >= 0 ; --v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAus*20;
                        Palatis::SoftPWM.set(Sig1_1, v);  // Hs1 rt
                        Palatis::SoftPWM.set(Sig1_4, v);  // Hs1 ws
                        }
                    }
                } 
            
            // ********************************************* Lampen Sig1 an         
            delay(wertWarte*2);
            if (Sig1 == 0 && (oldSig1 == 1 || oldSig1 == 3))  // wenn es Hp0 wird und Hp1/Hp2 war
                {
                // Serial.println("733, VS/HS, Sig1, Hp0 <- Hp1 o Hp2 ");  // Ausgabe
                if (sigMast1 == 0)                        // wenn Vorsignal am Mast
                    {
                    nextMicros = 0; 
                    for (int v = 0; v < 256 ; ++v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAn*20;    
                        Palatis::SoftPWM.set(Sig1_1, v);  // Hs1 rt
                        oldVS1=0;                         // setze Vorsignal auf ge/ge
                        }
                    delay(wertWarte*2);
                    nextMicros = 0;             
                    for (int v = 256; v >= 0 ; --v)       // Schalte altes Vs3 Signalbild aus
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAus*20;
                        Palatis::SoftPWM.set(Sig3_1, v);  // Vs3 ge1
                        Palatis::SoftPWM.set(Sig3_2, v);  // Vs3 ge2
                        }
                    }
                else                                      // Vorsignal separat
                    {
                    nextMicros = 0; 
                    for (int v = 0; v < 250 ; ++v) 
                        { 
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAn*20;
                        Palatis::SoftPWM.set(Sig1_1, v);  // Hs1 rot
                        Palatis::SoftPWM.set(Sig3_1, v);  // Vs3 ge1
                        Palatis::SoftPWM.set(Sig3_2, v);  // Vs3 ge2
                        }
                    }
                }   
            if (Sig1 == 0 && oldSig1 == 2)                // wenn es Hp0 wird und Sh1 war
                {
                // Serial.println("769, VS/HS, Sig1, Hp0 <- Sh1");  // Ausgabe
                if (sigMast1 == 0)                        // wenn Vorsignal am Mast
                    {
                    delay(wertWarte*2);
                    nextMicros = 0; 
                    for (int v = 0; v < 256 ; ++v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAn*20;    
                        Palatis::SoftPWM.set(Sig1_1, v);  // Hs1 rt
                        oldVS1=0;                         // setze Vorsignal auf ge/ge
                        }
                    }
                else                                      // Vorsignal separat
                    {
                    nextMicros = 0; 
                    for (int v = 0; v < 250 ; ++v) 
                        { 
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAn*20;
                        Palatis::SoftPWM.set(Sig1_1, v);  // Hs1 rt
                        }
                    }
                }
            if (Sig1 == 1)                                // wenn es Hp1 wird
                {
                // Serial.println("795, VS/HS, Sig1, Hp0 <- ");  // Ausgabe
                if (sigMast1 == 0)                        // wenn Vorsignal am Mast
                    {
                    nextMicros = 0; 
                    for (int v = 0; v < 256 ; ++v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAn*20;    
                        Palatis::SoftPWM.set(Sig1_2, v);  // Hs1 gn
                        // oldVS1=0;                      // setze Vorsignal auf ge/ge
                        }
                    }
                else                                              // Vorsignal separat
                    {
                    nextMicros = 0; 
                    for (int v = 0; v < 250 ; ++v) 
                        { 
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAn*20;
                        Palatis::SoftPWM.set(Sig1_2, v);          // Hs1 grün
                        Palatis::SoftPWM.set(Sig3_3, v);          // Vs3 gn1
                        Palatis::SoftPWM.set(Sig3_4, v);          // Vs3 gn2
                        }
                    }
                }    
            if (Sig1 == 3)                                        // wenn es Hp2 wird
                {
                // Serial.println("Zeile 821, VS/HS, Sig1, Hp2 <-");  // Ausgabe
                if (sigMast1 == 0)                                // wenn Vorsignal am Mast
                    {
                    nextMicros = 0; 
                    for (int v = 0; v < 256 ; ++v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAn*20;    
                        Palatis::SoftPWM.set(Sig1_2, v);          // Hs1 gn
                        Palatis::SoftPWM.set(Sig1_3, v);          // Hs1 ge
                        // oldVS1=0;                              // setze Vorsignal auf ge/ge
                        }
                    }
                else                                              // Vorsignal separat
                    {
                    nextMicros = 0; 
                    for (int v = 0; v < 250 ; ++v) 
                        { 
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAn*20;
                        Palatis::SoftPWM.set(Sig1_2, v);          // HS1 gn
                        Palatis::SoftPWM.set(Sig1_3, v);          // HS1 ge
                        Palatis::SoftPWM.set(Sig3_2, v);          // VS3 ge2
                        Palatis::SoftPWM.set(Sig3_3, v);          // VS3 gn1
                        }
                    }
                }
            if (Sig1 == 2 && oldSig1 == 0)                      // wenn es Sh1 wird und Hp0 war
                {
                // Serial.println("851, VS/HS, Sig1, Sh1 <- Hp0");  // Ausgabe
                if (sigMast1 == 0)                              // wenn Vorsignal am Mast
                    {
                    nextMicros = 0; 
                    for (int v = 0; v < 256 ; ++v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAn*20;    
                        Palatis::SoftPWM.set(Sig1_1, v);          // Hs1 rt
                        Palatis::SoftPWM.set(Sig1_4, v);          // Hs1 ws
                        oldVS1=0;                                 // setze Vorsignal auf ge/ge
                        }
                    }
                else                                              // Vorsignal separat
                    {
                    nextMicros = 0; 
                    for (int v = 0; v < 250 ; ++v) 
                        { 
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAn*20;
                        Palatis::SoftPWM.set(Sig1_1, v);          // Hs1 rt
                        Palatis::SoftPWM.set(Sig1_4, v);          // Hs1 ws
                        }
                    }
                }
            if (Sig1 == 2 && (oldSig1 == 1 || oldSig1 == 3))      // wenn es Sh1 wird und Hp1/Hp2 war
                {
                // Serial.println("Zeile 878, VS/HS, Sig1, Sh1 <- Hp1 o Hp2 ");  // Ausgabe
                if (sigMast1 == 0)                                // wenn Vorsignal am Mast
                    {
                    nextMicros = 0; 
                    for (int v = 0; v < 256 ; ++v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAn*20;    
                        Palatis::SoftPWM.set(Sig1_1, v);          // Hs1 rt
                        Palatis::SoftPWM.set(Sig1_4, v);          // Hs1 ws
                        oldVS1=0;                                 // setze Vorsignal auf ge/ge
                        }
                    delay(wertWarte*2);
                    nextMicros = 0;             
                    for (int v = 256; v >= 0 ; --v)               // Schalte altes Vs3 Signalbild aus
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAus*20;
                        Palatis::SoftPWM.set(Sig3_1, v);          // Vs3 ge1
                        Palatis::SoftPWM.set(Sig3_2, v);          // Vs3 ge2
                        }
                    }
                else                                              // Vorsignal separat
                    {
                    nextMicros = 0; 
                    for (int v = 0; v < 250 ; ++v) 
                        { 
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAn*20;
                        Palatis::SoftPWM.set(Sig1_1, v);          // Hs1 rt
                        Palatis::SoftPWM.set(Sig1_4, v);          // Hs1 ws
                        Palatis::SoftPWM.set(Sig3_1, v);          // Vs3 ge1
                        Palatis::SoftPWM.set(Sig3_2, v);          // Vs3 ge2
                        }
                   }
                }           
            oldSig1 = Sig1;                                       // aktueller Wert wird zu altem Wert
            }
        
        // ******************************************************    Signal 2     
        if (oldSig2 != Sig2)                                      // Daten haben sich auf dem Bus geändert?
            {                                         
            if (oldSig2 == 0 && (Sig2 == 4 || Sig2 ==12))         // wenn es Hp0 war und Hp1 oder Hp2 wird
                {
                // Serial.println("922, VS/HS, Sig2, Hp0 -> Hp1 o Hp2");  // Ausgabe
                if (sigMast2 == false)                            // wenn Vorsignal am Mast
                    {
                    nextMicros = 0;                               // Vorsignal an       
                    for (int v = 0; v < 256 ; ++v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAn*20;
                        Palatis::SoftPWM.set(Sig4_1, v);          // Vs4 ge1
                        Palatis::SoftPWM.set(Sig4_2, v);          // Vs4 ge2
                        }
                    oldVS2=0;                                     // setze Vorsignal auf ge/ge
                    nextMicros = 0;                               // Lampen aus       
                    for (int v = 255; v >= 0 ; --v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAus*20;
                        Palatis::SoftPWM.set(Sig2_1, v);          // Hs2 rot
                        }
                    }
                else                                              // wenn Vorsignal separat
                    {
                    nextMicros = 0;                               // Lampen aus       
                    for (int v = 255; v >= 0 ; --v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAus*20;
                        Palatis::SoftPWM.set(Sig2_1, v);          // Hs2 rot
                        Palatis::SoftPWM.set(Sig4_1, v);          // Vs4 ge1
                        Palatis::SoftPWM.set(Sig4_2, v);          // Vs4 ge2
                        }
                    }
                }
            if (oldSig2 == 0 && Sig2 == 8)                        // wenn es Hp0 war und Sh1 wird
                {
                // Serial.println("957, VS/HS, Sig2, Hp0 -> Sh1");// Ausgabe
                if (sigMast2 == false)                            // wenn Vorsignal am Mast
                    {
                    nextMicros = 0;                               // Lampen aus       
                    for (int v = 255; v >= 0 ; --v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAus*20;
                        Palatis::SoftPWM.set(Sig2_1, v);          // Hs2 rt
                        }
                    }
                else                                              // wenn Vorsignal separat
                    {
                    nextMicros = 0;                               // Lampen aus       
                    for (int v = 255; v >= 0 ; --v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAus*20;
                        Palatis::SoftPWM.set(Sig2_1, v);          // Hs2 rt
                        }
                    }
                } 
            if (oldSig2 == 4)                                     // wenn es Hp1 war
                {
                // Serial.println("981, VS/HS, Sig2, Hp1 ->");    // Ausgabe
                if (sigMast2 == false)                            // wenn Vorsignal am Mast
                    {
                    if (Sig2 == 0 || Sig2 == 8)                   // wenn es Hp0/Sh0 wird
                        {
                        if (oldVS2 == 1)                          // wenn Vs gn war
                            {
                            nextMicros = 0;                       // Lampen aus       
                            for (int v = 255; v >= 0 ; --v) 
                                {
                                while (micros() < nextMicros);
                                nextMicros = micros() + wertAus*20;
                                Palatis::SoftPWM.set(Sig4_3, v);  // Vs4 gn1
                                Palatis::SoftPWM.set(Sig4_4, v);  // Vs4 gn2
                                }
                            }
                        if (oldVS2 ==3)                          // wenn Vs gn/ge war
                            {
                            nextMicros = 0;                       // Lampen aus       
                            for (int v = 255; v >= 0 ; --v) 
                                {
                                while (micros() < nextMicros);
                                nextMicros = micros() + wertAus*20;
                                Palatis::SoftPWM.set(Sig4_2, v);  // Vs4 ge2
                                Palatis::SoftPWM.set(Sig4_3, v);  // Vs4 gn1
                                }
                            }
                        if (oldVS2 != 0 )                         // wenn Vs gn/ge war
                            {
                            // Serial.print("oldVS2...: ");       // Ausgabe
                            // Serial.println(oldVS2);            // Ausgabe
                            delay(wertWarte*2);
                            nextMicros = 0;                       // Vorsignal an       
                            for (int v = 0; v < 256 ; ++v) 
                                {
                                while (micros() < nextMicros);
                                nextMicros = micros() + wertAn*20;
                                Palatis::SoftPWM.set(Sig4_1, v);  // Vs4 ge1
                                Palatis::SoftPWM.set(Sig4_2, v);  // Vs4 ge2
                                }
                            }
                        }
                    nextMicros = 0;                               // Lampen aus       
                    for (int v = 255; v >= 0 ; --v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAus*20;
                        Palatis::SoftPWM.set(Sig2_2, v);          // Hs2 gn
                        }
                    }
                else                                              // wenn Vorsignal separat
                    {
                    nextMicros = 0;                               // Lampen aus       
                    for (int v = 255; v >= 0 ; --v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAus*20;
                        Palatis::SoftPWM.set(Sig2_2, v);          // Hs2 gn
                        Palatis::SoftPWM.set(Sig4_3, v);          // Vs4 gn1
                        Palatis::SoftPWM.set(Sig4_4, v);          // Vs4 gn2
                        }
                    }
                }
            if (oldSig2 == 12)                                    // wenn es Hp2 war
                {
                // Serial.println("1046, VS/HS, Sig2, Hp2 ->");   // Ausgabe
                if (sigMast2 == false)                            // wenn Vorsignal am Mast
                    {
                    if (Sig2 == 0 || Sig2 == 8)                   // wenn es Hp0/Sh1 wird
                        {
                        // Serial.println("1051, VS/HS, Sig2, Hp0/Sh1");  // Ausgabe
                        // Serial.println(oldVS2);                // Ausgabe
                        if (oldVS2 == 1)                          // wenn Vs gn war
                            {
                            // Serial.println("1056, VS/HS, Sig2, 4"); // Ausgabe
                            nextMicros = 0;                       // Lampen aus       
                            for (int v = 255; v >= 0 ; --v) 
                                {
                                while (micros() < nextMicros);
                                nextMicros = micros() + wertAus*20;
                                Palatis::SoftPWM.set(Sig4_3, v);  // Vs4 gn1
                                Palatis::SoftPWM.set(Sig4_4, v);  // Vs4 gn2
                                }
                            }
                        if (oldVS2 ==3)                          // wenn Vs gn/ge war
                            {
                            // Serial.println("1068, VS/HS, Sig2, 12"); // Ausgabe
                            nextMicros = 0;                       // Lampen aus       
                            for (int v = 255; v >= 0 ; --v) 
                                {
                                while (micros() < nextMicros);
                                nextMicros = micros() + wertAus*20;
                                Palatis::SoftPWM.set(Sig4_2, v);  // Vs4 ge2
                                Palatis::SoftPWM.set(Sig4_3, v);  // Vs4 gn1
                                }
                            }
                        if (oldVS2 != 0 )                         // wenn Vs gn/ge war
                            {
                            // Serial.println("1080, VS/HS, Sig2, 0"); // Ausgabe
                            // Serial.print("oldVS2...: ");       // Ausgabe
                            // Serial.println(oldVS2);            // Ausgabe
                            delay(wertWarte*2);
                            nextMicros = 0;                       // Vorsignal an       
                            for (int v = 0; v < 256 ; ++v) 
                                {
                                while (micros() < nextMicros);
                                nextMicros = micros() + wertAn*20;
                                Palatis::SoftPWM.set(Sig4_1, v);  // Vs4 ge1
                                Palatis::SoftPWM.set(Sig4_2, v);  // Vs4 ge2
                                }
                            }
                        }
                    nextMicros = 0;                               // Lampen aus       
                    for (int v = 255; v >= 0 ; --v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAus*20;
                        Palatis::SoftPWM.set(Sig2_2, v);          // Hs2 gn
                        Palatis::SoftPWM.set(Sig2_3, v);          // Hs2 ge
                        }
                    }
                else                                              // wenn Vorsignal separat
                    {
                    nextMicros = 0;                               // Lampen aus       
                    for (int v = 255; v >= 0 ; --v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAus*20;
                        Palatis::SoftPWM.set(Sig2_2, v);          // Hs2 gn
                        Palatis::SoftPWM.set(Sig2_3, v);          // Hs2 ge
                        Palatis::SoftPWM.set(Sig4_2, v);          // Vs4 ge2
                        Palatis::SoftPWM.set(Sig4_3, v);          // Vs4 gn1
                        }
                    }
                }              
            if (oldSig2 == 8 && (Sig2 == 4 || Sig2 ==12))         // wenn es Sh1 war und Hp1/Hp2 wird
                {
                // Serial.println("1120, VS/HS, Sig2, Sh1 -> Hp1 o Hp2");  // Ausgabe
                if (sigMast2 == false)                            // wenn Vorsignal am Mast
                    {
                    nextMicros = 0;                               // Vorsignal an       
                    for (int v = 0; v < 256 ; ++v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAn*20;
                        Palatis::SoftPWM.set(Sig4_1, v);          // Vs4 ge1
                        Palatis::SoftPWM.set(Sig4_2, v);          // Vs4 ge2
                        }
                    oldVS2=0;                                     // setze Vorsignal auf ge/ge
                    nextMicros = 0;                               // Lampen aus       
                    for (int v = 255; v >= 0 ; --v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAus*20;
                        Palatis::SoftPWM.set(Sig2_1, v);          // HS2 rot
                        Palatis::SoftPWM.set(Sig2_4, v);          // HS2 ws
                        }
                    }
                else                                              // wenn Vorsignal separat
                    {
                    nextMicros = 0;                               // Lampen aus       
                    for (int v = 255; v >= 0 ; --v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAus*20;
                        Palatis::SoftPWM.set(Sig2_1, v);          // Hs2 rot
                        Palatis::SoftPWM.set(Sig2_4, v);          // Hs2 ws
                        Palatis::SoftPWM.set(Sig4_1, v);          // Vs4 ge1
                        Palatis::SoftPWM.set(Sig4_2, v);          // Vs4 ge2
                        }
                    }
                } 
            if (oldSig2 == 8 && Sig2 == 0)                        // wenn es Sh1 war und Hp0 wird
                {
                // Serial.println("1157, VS/HS, Sig2, Sh1 -> Hp0");  // Ausgabe
                if (sigMast2 == false)                            // wenn Vorsignal am Mast
                    {
                    nextMicros = 0;                               // Lampen aus       
                    for (int v = 255; v >= 0 ; --v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAus*20;
                        Palatis::SoftPWM.set(Sig2_1, v);          // Hs2 rt
                        Palatis::SoftPWM.set(Sig2_4, v);          // Hs2 ws
                        }
                    }
                else                                              // wenn Vorsignal separat
                    {
                    nextMicros = 0;                               // Lampen aus       
                    for (int v = 255; v >= 0 ; --v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAus*20;
                        Palatis::SoftPWM.set(Sig2_1, v);          // Hs2 rt
                        Palatis::SoftPWM.set(Sig2_4, v);          // Hs2 ws
                        }
                    }
                } 
            // ***************************************************   Lampen Sig2 an         
            delay(wertWarte*2);
            if (Sig2 == 0 && (oldSig2 == 4 || oldSig2 ==12))      // wenn es Hp0 wird und Hp1/Hp2 war
                {
                // Serial.println("1185, VS/HS, Sig2, Hp0 <- Hp1 o Hp2");  // Ausgabe
                if (sigMast2 == 0)                                // wenn Vorsignal am Mast
                    {
                    nextMicros = 0; 
                    for (int v = 0; v < 256 ; ++v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAn*20;    
                        Palatis::SoftPWM.set(Sig2_1, v);          // Hs2 rt
                        oldVS2=0;                                 // setze Vorsignal auf ge/ge
                        }
                    delay(wertWarte*2);
                    nextMicros = 0;             
                    for (int v = 256; v >= 0 ; --v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAus*20;
                        Palatis::SoftPWM.set(Sig4_1, v);          // Vs4 ge1
                        Palatis::SoftPWM.set(Sig4_2, v);          // Vs4 ge2
                         }
                    }
                else                                              // Vorsignal separat
                    {
                    nextMicros = 0; 
                    for (int v = 0; v < 250 ; ++v) 
                        { 
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAn*20;
                        Palatis::SoftPWM.set(Sig2_1, v);          // Hs2 rot
                        Palatis::SoftPWM.set(Sig4_1, v);          // Vs4 ge1
                        Palatis::SoftPWM.set(Sig4_2, v);          // Vs4 ge2
                        }
                    }
                }   
            if (Sig2 == 0 && oldSig2 == 8)                        // wenn es Hp0 wird und Sh1 war
                {
                // Serial.println("1221, VS/HS, Sig2, Hp0 <- Sh1");  // Ausgabe
                if (sigMast2 == 0)                                // wenn Vorsignal am Mast
                    {
                    nextMicros = 0;             
                    for (int v = 0; v < 256 ; ++v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAn*20;    
                        Palatis::SoftPWM.set(Sig2_1, v);          // Hs2 rt
                        oldVS2=0;                                 // setze Vorsignal auf ge/ge
                        }
                    }
                else                                              // Vorsignal separat
                    {
                    nextMicros = 0; 
                    for (int v = 0; v < 250 ; ++v) 
                        { 
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAn*20;
                        Palatis::SoftPWM.set(Sig2_1, v);          // Hs2 rt
                        }
                    }
                }
            if (Sig2 == 4)                                        // wenn es Hp1 wird
                {
                // Serial.println("1246, VS/HS, Sig2, Hp1 <-");   // Ausgabe
                if (sigMast2 == 0)                                // wenn Vorsignal am Mast
                    {
                    nextMicros = 0;             
                    for (int v = 0; v < 256 ; ++v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAn*20;    
                        Palatis::SoftPWM.set(Sig2_2, v);          // Hs2 gn
                        // oldVS2=0;                              // setze Vorsignal auf ge/ge
                        }
                    }
                else                                              // Vorsignal separat
                    {
                    nextMicros = 0; 
                    for (int v = 0; v < 250 ; ++v) 
                        { 
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAn*20;
                        Palatis::SoftPWM.set(Sig2_2, v);          // Hs2 grün
                        Palatis::SoftPWM.set(Sig4_3, v);          // Vs4 gn1
                        Palatis::SoftPWM.set(Sig4_4, v);          // Vs4 gn2
                        }
                    }
                }    
            if (Sig2 ==12)                                        // wenn es Hp2 wird
                {
                // Serial.println("1273, VS/HS, Sig2, Hp2 <-");   // Ausgabe
                if (sigMast2 == 0)                                // wenn Vorsignal am Mast
                    {
                    nextMicros = 0;             
                    for (int v = 0; v < 256 ; ++v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAn*20;    
                        Palatis::SoftPWM.set(Sig2_2, v);          // HS2 gn
                        Palatis::SoftPWM.set(Sig2_3, v);          // HS2 ge
                        // oldVS2=0;                              // setze Vorsignal auf ge/ge
                        }
                    }
                else                                              // Vorsignal separat
                    {
                    nextMicros = 0; 
                    for (int v = 0; v < 250 ; ++v) 
                        { 
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAn*20;
                        Palatis::SoftPWM.set(Sig2_2, v);          // HS2 gn
                        Palatis::SoftPWM.set(Sig2_3, v);          // HS2 ge
                        Palatis::SoftPWM.set(Sig4_2, v);          // VS4 ge2
                        Palatis::SoftPWM.set(Sig4_3, v);          // VS4 gn1
                        }
                    }
                }
            if (Sig2 == 8 && oldSig2 == 0)                        // wenn es Sh1 wird und Hp0 war
                {
                // Serial.println("Zeile 1295, VS/HS, Sig2, Sh1 <- Hp0");  // Ausgabe
                if (sigMast2 == 0)                                // wenn Vorsignal am Mast
                    {
                    nextMicros = 0;             
                    for (int v = 0; v < 256 ; ++v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAn*20;    
                        Palatis::SoftPWM.set(Sig2_1, v);          // Hs2 rt
                        Palatis::SoftPWM.set(Sig2_4, v);          // Hs2 ws
                        oldVS2=0;                                 // setze Vorsignal auf ge/ge
                        }
                    }
                else                                              // Vorsignal separat
                    {
                    nextMicros = 0; 
                    for (int v = 0; v < 250 ; ++v) 
                        { 
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAn*20;
                        Palatis::SoftPWM.set(Sig2_1, v);          // Hs2 rt
                        Palatis::SoftPWM.set(Sig2_4, v);          // Hs2 ws
                        }
                    }
                }
            if (Sig2 == 8 && (oldSig2 == 4 || oldSig2 ==12))      // wenn es Sh1 wird und Hp1/Hp2 war
                {
                // Serial.println("1322, VS/HS, Sig2, Sh1 <- Hp1 o Hp2");  // Ausgabe
                if (sigMast2 == 0)                                // wenn Vorsignal am Mast
                    {
                    nextMicros = 0;             
                    for (int v = 0; v < 256 ; ++v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAn*20;    
                        Palatis::SoftPWM.set(Sig2_1, v);          // Hs2 rt
                        Palatis::SoftPWM.set(Sig2_4, v);          // Hs2 ws
                        oldVS2=0;                                 // setze Vorsignal auf ge/ge
                        }
                    delay(wertWarte*2);
                    nextMicros = 0;
                    for (int v = 256; v >= 0 ; --v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAus*20;
                        Palatis::SoftPWM.set(Sig4_1, v);          // Vs4 ge1
                        Palatis::SoftPWM.set(Sig4_2, v);          // Vs4 ge2
                         }
                    }
                else                                              // Vorsignal separat
                    {
                    nextMicros = 0; 
                    for (int v = 0; v < 250 ; ++v) 
                        { 
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAn*20;
                        Palatis::SoftPWM.set(Sig2_1, v);          // Hs2 rt
                        Palatis::SoftPWM.set(Sig2_4, v);          // Hs2 ws
                        Palatis::SoftPWM.set(Sig4_1, v);          // Vs4 ge1
                        Palatis::SoftPWM.set(Sig4_2, v);          // Vs4 ge2
                        }
                   }
                }           
            oldSig2 = Sig2;                                       // aktueller Wert wird zu altem Wert
            }
        }          

    // ************************************************************* Vorsignalberechnung
    if (sigMast1 == false && sigMod == false)                     // wenn Vorsignal und Vorsignal am Mast
        {
        SxData2=SXbus.read(VS1Adr);                               // Adresse des Hs auslesen
        if (VS1nr==16)                                            // Wenn Hauptsignal 2 gehört zu VS1
            {
            SxData2 = SxData2 >> 2;                               // VS1
            }
        else if (VS1nr==32)                                       // Wenn Hauptsignal 3 gehört zu VS1
            {
            SxData2 = SxData2 >> 4;                               // VS1
            }
        else if (VS1nr==48)                                       // Wenn Hauptsignal 4 gehört zu VS1
            {
            SxData2 = SxData2 >> 6;                               // VS1 
            } 

        VS1 = SxData2 & B00000011;                                // Signalbid vom Hs1
        if (oldVS1 != VS1)                                        // Hs des Vs hat sich geändert?
            {
            // Serial.println("Vs1 geändert");                    // Ausgabe
            /*
            Serial.print("VS1nr.......: ");                       // Ausgabe
            Serial.println(VS1nr);                                // Ausgabe
            Serial.print("oldVS1...: ");                          // Ausgabe
            Serial.println(oldVS1);                               // Ausgabe
            Serial.print("VS1.......: ");                         // Ausgabe
            Serial.println(VS1);                                  // Ausgabe
            Serial.println(" ");                                  // Ausgabe
            */
            if (Sig1 == 1 || Sig1 == 3)                           // wenn Hs1 am Mast von Vs1 nicht rot ist
                {
                // Serial.println("Hs1 nicht rot ");              // Ausgabe
                if (oldVS1 == 0 || oldVS1 == 2)                   // wenn Vs1 am Mast Hp0 oder Sh1 war
                    {
                    // Serial.println("Zeile 1386, Vs1 war Hp0 o Sh1 ");  // Ausgabe
                    nextMicros = 0;                               // Lampen aus       
                    for (int v = 255; v >= 0 ; --v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAus*20;
                        Palatis::SoftPWM.set(Sig3_1, v);          // VS3 ge1
                        Palatis::SoftPWM.set(Sig3_2, v);          // VS3 ge2
                        }
                    }
                if (oldVS1 == 1)                                  // wenn VS1 am Mast gn war
                    {
                    // Serial.println("Zeile 1398, Vs1 <- Vr1 "); // Ausgabe
                    nextMicros = 0;                               // Lampen aus       
                    for (int v = 255; v >= 0 ; --v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAus*20;
                        Palatis::SoftPWM.set(Sig3_3, v);          // VS3 gn1
                        Palatis::SoftPWM.set(Sig3_4, v);          // VS3 gn2
                        }
                    }
                if (oldVS1 == 3)                                  // wenn VS1 am Mast ge/gn war
                    {
                    // Serial.println("Zeile 1410, Vs1 <- Vr2 "); // Ausgabe
                    nextMicros = 0;                               // Lampen aus       
                    for (int v = 255; v >= 0 ; --v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAus*20;
                        Palatis::SoftPWM.set(Sig3_2, v);          // VS3 ge2
                        Palatis::SoftPWM.set(Sig3_3, v);          // VS3 gn1
                        }             
                    }
                delay(wertWarte*2);                               // warte bis die Lampen wieder an gehen
                // ************************************************* schalte entsprechende Leds ein
                if (VS1 == 0 || VS1 == 2)                         // Signal 3 rot
                    {
                    // Serial.println("Zeile 1426, Vs1 -> Vr0");  // Ausgabe
                    nextMicros = 0;             
                    for (int v = 0; v < 250 ; ++v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAn*20;
                        Palatis::SoftPWM.set(Sig3_1, v);          // VS1 ge1
                        Palatis::SoftPWM.set(Sig3_2, v);          // VS1 ge2
                        }
                    }
                if (VS1 == 1)                                     // Signal 3 gn
                    {
                    // Serial.println("Zeile 1438, Vs1 -> Vr1");  // Ausgabe
                    nextMicros = 0;             
                    for (int v = 0; v < 250 ; ++v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAn*20;
                        Palatis::SoftPWM.set(Sig3_3, v);          // VS1 gn1
                        Palatis::SoftPWM.set(Sig3_4, v);          // VS1 gn2
                        }
                    }
                if (VS1 == 3)                                     // Signal 3 ge/gn
                    {
                    // Serial.println("Zeile 1450, Vs1 -> Vr2 "); // Ausgabe
                    nextMicros = 0;             
                    for (int v = 0; v < 250 ; ++v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAn*20;
                        Palatis::SoftPWM.set(Sig3_2, v);          // VS3 ge2
                        Palatis::SoftPWM.set(Sig3_3, v);          // VS3 gn1
                        }
                    }
                }
            oldVS1 = VS1;                                         // aktueller Wert wird zu altem Wert
            }
        }
    // ************************************************************* Vorsignal 2
    if (sigMast2 == false && sigMod == false)                     // wenn Vorsignal und Vorsignal am Mast
        {
        SxData3=SXbus.read(VS2Adr);                               // Adresse des Hs auslesen
        if (VS2nr==64)                                            // Wenn Hauptsignal 2 gehört zu VS2
            {
            SxData3 = SxData3 >> 2;                               // VS2
            }
        else if (VS2nr==128)                                      // Wenn Hauptsignal 3 gehört zu VS2
            {
            SxData3 = SxData3 >> 4;                               // VS2
            }
        else if (VS2nr==192)                                      // Wenn Hauptsignal 4 gehört zu VS2
            {
            SxData3 = SxData3 >> 6;                               // VS2 
            } 
        VS2 = SxData3 & B00000011;                                // Signalbid vom Hs2
        if (oldVS2 != VS2)                                        // Hs des Vs hat sich geändert?
            {
            // Serial.println("1493, Vs2 geändert");              // Ausgabe
            // Serial.println(oldVS2);                            // Ausgabe
                    
            if (Sig2 == 4 || Sig2 == 12)                          // wenn Hs2 am Mast von Vs2 nicht rot ist
                {
                if (oldVS2 == 0 || oldVS2 == 2)                   // wenn Vs2 am Mast Hp0 oder Sh1 war
                    {
                    // Serial.println("1498, Hs2 nicht Hp0/Sh1 ");// Ausgabe
                    nextMicros = 0;                               // Lampen aus       
                    for (int v = 255; v >= 0 ; --v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAus*20;
                        Palatis::SoftPWM.set(Sig4_1, v);          // VS4 ge1
                        Palatis::SoftPWM.set(Sig4_2, v);          // VS4 ge2
                        }
                    }
                if (oldVS2 == 1)                                  // wenn VS2 am Mast gn war
                    {
                    // Serial.println("1510, VS/HS, Sig2, gn ->");// Ausgabe
                    nextMicros = 0;                               // Lampen aus       
                    for (int v = 255; v >= 0 ; --v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAus*20;
                        Palatis::SoftPWM.set(Sig4_3, v);          // VS4 gn1
                        Palatis::SoftPWM.set(Sig4_4, v);          // VS4 gn2
                        }
                    }
                if (oldVS2 == 3)                                  // wenn VS4 am Mast ge/gn war
                    {
                    // Serial.println("1522, VS/HS, Sig2, gn(ge ->"); // Ausgabe
                    nextMicros = 0;                               // Lampen aus       
                    for (int v = 255; v >= 0 ; --v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAus*20;
                        Palatis::SoftPWM.set(Sig4_2, v);          // VS4 ge2
                        Palatis::SoftPWM.set(Sig4_3, v);          // VS4 gn1
                        }             
                    }
                delay(wertWarte*2);                               // warte bis die Lampen wieder an gehen
                // ************************************************* schalte entsprechende Leds ein
                if (VS2 == 0 || VS2 == 2)                         // Signal 4 ge
                    {
                    // Serial.println("Zeile 1536, VS/HS, Sig2,  -> Vr0");  // Ausgabe
                    nextMicros = 0;             
                    for (int v = 0; v < 250 ; ++v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAn*20;
                        Palatis::SoftPWM.set(Sig4_1, v);          // VS4 ge1
                        Palatis::SoftPWM.set(Sig4_2, v);          // VS4 ge2
                        }
                    }
                if (VS2 == 1)                                     // Signal 4 gn
                    {
                    // Serial.println("Zeile 1548, VS/HS, Sig2, -> Vr1");  // Ausgabe
                    nextMicros = 0;             
                    for (int v = 0; v < 250 ; ++v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAn*20;
                        Palatis::SoftPWM.set(Sig4_3, v);          // VS4 gn1
                        Palatis::SoftPWM.set(Sig4_4, v);          // VS4 gn2
                        }
                    }
                if (VS2 == 3)                                     // Signal 4 ge/gn
                    {
                    // Serial.println("Zeile 1560, VS/HS, Sig2, -> Vr2");  // Ausgabe
                    nextMicros = 0;             
                    for (int v = 0; v < 250 ; ++v) 
                        {
                        while (micros() < nextMicros);
                        nextMicros = micros() + wertAn*20;
                        Palatis::SoftPWM.set(Sig4_2, v);          // VS4 ge2
                        Palatis::SoftPWM.set(Sig4_3, v);          // VS4 gn1
                        }
                    }
                }
            oldVS2 = VS2;                                       // aktueller Wert wird zu altem Wert
            }
        }
    
    // ************************************************* Programmierroutine       
    if (progAkt == 0)                                 // wenn progAktiv nicht gesetzt
        {
        tb = SXbus.readPWR();                         // Info, ob das Gleissignal an/aus ist
        Prog = analogRead(analogPin);                 // read the input pin 
        if (Prog <= 500 && tb ==false)                // falls gedrückt und Gleis aus
            {
            SxData1 = SXbus.read(106);                // Sx-Adr 106 auslesen
            Vergleich = SxData1 & B00100000;          // Prog schon von anderem Decoder gesetzt?
            if (Vergleich != 32)
                {
                progAkt = 1;                          // setze progAktiv
                // Serial.println("Prog an");         // Ausgabe
                // digitalWrite(Bit_16,HIGH);         // Prog-Led einschalten
                Palatis::SoftPWM.set(Sig1_4, 255);    // Prog-Led einschalten
                SxDataSchreib = SxData1 | B00100000;  // Prog-Bit setzen
                SxAdrSchreib = 106;                   // Sx Adresse die beschrieben werden soll
                Schreiben();                          // ins Unterprog springen
                delay (500);                          // warte
                SxData1=SXbus.read(0);                // Sx-Adr 00 auslesen
                EEPROM.write(10,SxData1);             // und in eEprom retten           
                SxData1=SXbus.read(1);                // Sx-Adr 01 auslesen
                EEPROM.write(11,SxData1);             // und in eEprom retten           
                SxData1=SXbus.read(2);                // Sx-Adr 02 auslesen
                EEPROM.write(12,SxData1);             // und in eEprom retten           
                SxData1=SXbus.read(3);                // Sx-Adr 03 auslesen
                EEPROM.write(13,SxData1);             // und in eEprom retten           
                SxData1=SXbus.read(4);                // Sx-Adr 04 auslesen
                EEPROM.write(14,SxData1);             // und in eEprom retten              
                SxData1=SXbus.read(5);                // Sx-Adr 05 auslesen
                EEPROM.write(15,SxData1);             // und in eEprom retten
                SxData1=SXbus.read(6);                // Sx-Adr 06 auslesen
                EEPROM.write(16,SxData1);             // und in eEprom retten           
                SxData1=SXbus.read(7);                // Sx-Adr 07 auslesen
                EEPROM.write(17,SxData1);             // und in eEprom retten           
                SxData1=SXbus.read(8);                // Sx-Adr 08 auslesen
                EEPROM.write(18,SxData1);             // und in eEprom retten           
                SxData1=SXbus.read(9);                // Sx-Adr 09 auslesen
                EEPROM.write(19,SxData1);             // und in eEprom retten
                DecAdr = EEPROM.read(1);              // EEprom Zelle 1 auslesen
                // Serial.print(DecAdr);              // schreibe
                SxAdrSchreib=0;                       // Sx Adresse die beschrieben werden soll
                SxDataSchreib=DecAdr;                 // setze Wert der geschrieben werden soll
                Schreiben();                          // ins Unterprog springen
                wertAus = EEPROM.read(2);             // EEprom Zelle 2 auslesen
                SxAdrSchreib=1;                       // setze Adresse die geschrieben werden soll
                SxDataSchreib=wertAus;                // setze Wert der geschrieben werden soll
                Schreiben();                          // ins Unterprog springen                    
                wertAn = EEPROM.read(3);              // EEprom Zelle 3 auslesen
                SxAdrSchreib=2;                       // setze Adresse die geschrieben werden soll
                SxDataSchreib=wertAn;                 // setze Wert der geschrieben werden soll
                Schreiben();                          // ins Unterprog springen                    
                wertWarte = EEPROM.read(4);           // EEprom Zelle 4 auslesen
                SxAdrSchreib=3;                       // setze Adresse die geschrieben werden soll
                SxDataSchreib=wertWarte;              // setze Wert der geschrieben werden soll
                Schreiben();                          // ins Unterprog springen                    
                Modus = EEPROM.read(5);               // EEprom Zelle 5 auslesen
                SxAdrSchreib=4;                       // setze Adresse die geschrieben werden soll
                SxDataSchreib=Modus;                  // setze Wert der geschrieben werden soll
                Schreiben();                          // ins Unterprog springen                    
                VS1Adr= EEPROM.read(6);               // EEprom Zelle 6 auslesen
                SxAdrSchreib=5;                       // setze Adresse die geschrieben werden soll
                SxDataSchreib=VS1Adr;                 // setze Wert der geschrieben werden soll
                Schreiben();                          // ins Unterprog springen
                VS2Adr = EEPROM.read(7);              // EEprom Zelle 7 auslesen
                SxAdrSchreib=6;                       // setze Adresse die geschrieben werden soll
                SxDataSchreib=VS2Adr;                 // setze Wert der geschrieben werden soll
                Schreiben();                          // ins Unterprog springen
                }            
            else
                {
                // Serial.println("Prog ist schon an");  
                Palatis::SoftPWM.set(Sig1_3, 255);    // Led einschalten
                }
            delay (1500);                             // warte
            Palatis::SoftPWM.set(Sig1_3, 0);          // Led einschalten
            }
        } 
    // ************************************************* Programmierroutine schreiben
    if (progAkt == 1)                                 // wenn progAktiv gesetzt
        {
        tb = SXbus.readPWR();                         // Info, ob das Gleissignal an/aus ist              
        Prog = analogRead(analogPin);                 // read the input pin 
        if (Prog <= 500 || tb ==true)                 // falls gedrückt oder Gleis ein
            {
            // Serial.println("Start speichern");     // Ausgabe
            DecAdr=SXbus.read(0);                     // Sx-Adr 00 auslesen
            EEPROM.write(1,DecAdr);                   // in eEprom schreiben            
            wertAus = SXbus.read(1);                  // Sx-Adr 01 auslesen
            EEPROM.write(2,wertAus);                  // in eEprom schreiben
            wertAn = SXbus.read(2);                   // Sx-Adr 02 auslesen
            EEPROM.write(3,wertAn);                   // in eEprom schreiben
            wertWarte = SXbus.read(3);                // Sx-Adr 03 auslesen
            EEPROM.write(4,wertWarte);                // in eEprom schreiben
            Modus = SXbus.read(4);                    // Sx-Adr 04 auslesen
            EEPROM.write(5,Modus);                    // in eEprom schreiben
            VS1Adr = SXbus.read(5);                   // Sx-Adr 05 auslesen
            EEPROM.write(6,VS1Adr);                   // in eEprom schreiben
            VS2Adr = SXbus.read(6);                   // Sx-Adr 06 auslesen
            EEPROM.write(7,VS2Adr);                   // in eEprom schreiben
            Grundstellung();                          // springe zum Unterprogramm
            // halbByte = Modus & B00000100;          // Bit 3 überprüfen (0=oberes/1=unteres AdrByte)
            SxDataSchreib = EEPROM.read(10);          // EEprom Zelle 10 mit geretteten auslesen
            SxAdrSchreib=0;                           // Sx Adresse die beschrieben werden soll
            Schreiben();                              // ins Unterprog springen           
            SxDataSchreib = EEPROM.read(11);          // EEprom Zelle 11 mit geretteten auslesen
            SxAdrSchreib=1;                           // Sx Adresse die beschrieben werden soll
            Schreiben();                              // ins Unterprog springen           
            SxDataSchreib = EEPROM.read(12);          // EEprom Zelle 12 mit geretteten auslesen
            SxAdrSchreib=2;                           // Sx Adresse die beschrieben werden soll
            Schreiben();                              // ins Unterprog springen           
            SxDataSchreib = EEPROM.read(13);          // EEprom Zelle 13 mit geretteten auslesen
            SxAdrSchreib=3;                           // Sx Adresse die beschrieben werden soll
            Schreiben();                              // ins Unterprog springen           
            SxDataSchreib = EEPROM.read(14);          // EEprom Zelle 14 mit geretteten auslesen
            SxAdrSchreib=4;                           // Sx Adresse die beschrieben werden soll
            Schreiben();                              // ins Unterprog springen           
            SxDataSchreib = EEPROM.read(15);          // EEprom Zelle 15 mit geretteten auslesen
            SxAdrSchreib=5;                           // Sx Adresse die beschrieben werden soll
            Schreiben();                              // ins Unterprog springen
            SxDataSchreib = EEPROM.read(16);          // EEprom Zelle 12 mit geretteten auslesen
            SxAdrSchreib=6;                           // Sx Adresse die beschrieben werden soll
            Schreiben();                              // ins Unterprog springen           
            SxDataSchreib = EEPROM.read(17);          // EEprom Zelle 13 mit geretteten auslesen
            SxAdrSchreib=7;                           // Sx Adresse die beschrieben werden soll
            Schreiben();                              // ins Unterprog springen           
            SxDataSchreib = EEPROM.read(18);          // EEprom Zelle 14 mit geretteten auslesen
            SxAdrSchreib=8;                           // Sx Adresse die beschrieben werden soll
            Schreiben();                              // ins Unterprog springen           
            SxDataSchreib = EEPROM.read(19);          // EEprom Zelle 15 mit geretteten auslesen
            SxAdrSchreib=9;                           // Sx Adresse die beschrieben werden soll
            Schreiben();                              // ins Unterprog springen           
            SxData1=SXbus.read(106);                  // Sx-Adr 106 auslesen
            SxDataSchreib=SxData1 & B11011111;        // Prog-Bit zurück setzen
            SxAdrSchreib=106;                         // Sx Adresse die beschrieben werden soll
            Schreiben();                              // ins Unterprog springen
            delay(1000);                              // warte
            progAkt = 0;                              // lösche progAktiv
            // Serial.println("Prog aus");            // Ausgabe
            // digitalWrite(Bit_16,LOW);              // Led ausschalten
            Palatis::SoftPWM.set(Sig1_4, 0);          // Led ausschalten
            }
        }
    }

void Schreiben()
    {
    SXbus.write(SxAdrSchreib,SxDataSchreib);          // Decoderadr auf Sx-Bus in Adr 0 schreiben
    }

void Grundstellung()
    {
    sigMod =   Modus & B00000001;                     // Bit 1 überprüfen (0=Haupt/Vor ; 1=2x Haupt)
    sigMast1 = Modus & B00000010;                     // Bit 2 überprüfen (0=am Mast ; 1=separat)
    sigMast2 = Modus & B00000100;                     // Bit 3 überprüfen (0=am Mast ; 1=separat)
    halbByte = Modus & B00001000;                     // Bit 4 überprüfen (0=oberes/1=unteres AdrByte)
    VS1nr    = Modus & B00110000;                     // zu welchem Hs gehört Vs1 (1-4)
    VS2nr    = Modus & B11000000;                     // zu welchem Hs gehört Vs2 (1-4)
    Palatis::SoftPWM.set( 0, 0);                      // alle Leds aus
    Palatis::SoftPWM.set( 1, 0);
    Palatis::SoftPWM.set( 5, 0);
    for (int i = 7; i < 20 ; ++i) 
        {
        Palatis::SoftPWM.set( i, 0);
        }
    if (sigMod == 1)                                  // sigMod = 1 dann nur Hauptsignale
        {
        Palatis::SoftPWM.set(Sig1_1, 255);            // Hs1 rt 
        Palatis::SoftPWM.set(Sig2_1, 255);            // Hs2 rt
        Palatis::SoftPWM.set(Sig3_1, 255);            // Hs3 rt
        Palatis::SoftPWM.set(Sig4_1, 255);            // Hs4 rt
        } 
    if (sigMod == 0)                                  // sigMod = 0 dann mit Vorsignale
        {                                      
        if (sigMast1 == 0)                            // sigMast1 = 0 dann am Mast
            {
            Palatis::SoftPWM.set(Sig1_1, 255);        // Hs1 rot
            }
        else                                          // sigMast1 = 1 dann separat
            {
            Palatis::SoftPWM.set(Sig1_1, 255);        // Hs1 rot
            Palatis::SoftPWM.set(Sig3_1, 255);        // Vs3 ge1
            Palatis::SoftPWM.set(Sig3_2, 255);        // Vs3 ge2
            }
        if (sigMast2 == 0)                            // sigMast2 = 0 dann am Mast
            {
            Palatis::SoftPWM.set(Sig2_1, 255);        // Hs2 rot
            }
        else                                          // sigMast2 = 1 dann separat
            {
            Palatis::SoftPWM.set(Sig2_1, 255);        // Hs2 rot
            Palatis::SoftPWM.set(Sig4_1, 255);        // Vs4 ge1
            Palatis::SoftPWM.set(Sig4_2, 255);        // Vs4 ge2
            }
        }
    /*
    Serial.println("...");               // Ausgabe
    Serial.print("DecAdr...: ");         // Ausgabe
    Serial.println(DecAdr);              // Ausgabe
    Serial.print("wertAus..: ");         // Ausgabe
    Serial.println(wertAus);             // Ausgabe
    Serial.print("wertAn...: ");         // Ausgabe
    Serial.println(wertAn);              // Ausgabe
    Serial.print("wertWarte: ");         // Ausgabe
    Serial.println(wertWarte);           // Ausgabe
    Serial.print("sigMod...: ");         // Ausgabe
    Serial.println(sigMod);              // Ausgabe
    Serial.print("DecMast..: ");         // Ausgabe
    Serial.println(sigMast1);            // Ausgabe
    Serial.println(sigMast2);            // Ausgabe
    Serial.print("VS1Adr...: ");         // Ausgabe
    Serial.println(VS1Adr);              // Ausgabe
    Serial.print("VS1nr....: ");         // Ausgabe
    Serial.println(VS1nr);               // Ausgabe
    Serial.print("VS2Adr...: ");         // Ausgabe
    Serial.println(VS2Adr);              // Ausgabe
    Serial.print("VS2nr....: ");         // Ausgabe
    Serial.println(VS2nr);               // Ausgabe
    */
    }
