/*  
 *  File:       SxNano_RFID_Zugerkennung_SD_V34.ino
 *  Autor:      Frank Keil
 *  Controller: Arduino Nano (5V, 16MHz), ATmega328
 *  Hardware:   Sx-Decoder von Frank Keil 
 *              http://frank-keil.de/Selectrix/Sx-Decoder/Sx-Decoder.html
 *              
 *  
 *  Libraries:  - SXArduino: Quellen von G.v.d.Sel  
 *                https://github.com/gvandersel/SXArduino
 *              - RFID
 *              - SD
 *              - EEprom
 *
 *  Created on: 02.01.2012
 *  Last changed on: 03.10.2025
 *  
 *  Beschreibung:
 *  Zugerkennung mit RFID
 *  Die Lokadresse wird auf den Sx-Bus (Bus-Adresse einstellbat) geschrieben
 *  Max Anzahl Loknummern = 100
 *
 *  ------------------------------------------------------------
 *  Pin layout should be as follows:
 *  Signal     Pin              Pin               Pin
 *            Arduino Uno      ESP8266      MFRC522 board
 *  ------------------------------------------------------------
 *  Reset      9                5                 RST
 *  SPI SS     10               4                 SDA
 *  SPI MOSI   11               13                MOSI
 *  SPI MISO   12               12                MISO
 *  SPI SCK    13               14                SCK  
 *
 *  
 *  Bit_15 signalisiert die Gleisspannung     (Bit_4 wegen RFID)
 *  Bit_16 ist während der Programmierung an  (Bit_5 wegen RFID)
 *  analogPin -> Programmiertaster
 *  analogWahl-> Wahlschalter
 *
 */

  // Allgemein
  unsigned int analogPin = 6;                   // Progtaster
  // #define Bit_3 5                               // Led 3
  // #define Bit_4 7                               // Led 4
  // #define Bit_5 8                               // Led 5
  int  progAkt;                                // Programmierung aktiv
  int  Prog = 0;                               // Analogwert Progtaster
  // boolean first=0;                           // erster Durchlauf
  byte i;                                       // Zählvariable
  // byte EEAdr[100];                           // 
  unsigned int ZugIDNr[100];                     // Array mit den UID's
  byte LokAdrNr[100];                            // Array mit der Lokadresse byte aktGleis;                             
  byte LokNr;                                   // Lok-Nr laut SCRB60
  // byte GleisNr[100];                         // Array mit den Gleisnummern

  // RFID Parameter
  #include <RFID.h>                             // bindet Bibliothek MFRC522 ein
  //#define SS_PIN 10                           // Definition des Pin 10
  //#define RST_PIN 9                           // Definition des Pin 9
  //RFID rfid(SS_PIN,RST_PIN);
  RFID rfid(10,9);

  #include <SPI.h>                              // bindet Bibliothek SPI ein
  unsigned int UID=0;                           // aktuell gelesener Code
  unsigned int oldUID=0;                        // zuletzt gelesener Code
  byte b1;                                      // Byte 1 der UID
  byte b2;                                      // Byte 2 der UID
  byte b3;                                      // Byte 3 der UID
  byte b4;                                      // Byte 4 der UID
  unsigned int UIDhigh;                         // berechnete UID
  unsigned int UIDlow;                          // berechnete UID

  // SD Parameter
  // #include <SPI.h>                           // library
  #include <SD.h>                               // SD Bibliothek hinzufügen
  #include <EEPROM.h>                           // EEPROM Bibliothek hinzufügen
  int var1;
  int var2;
  int var3;
  int var4;
  const byte chipSelectPin = 8;                 // Ansteuerpin für die SD-Karte
  const String filename = "lok.txt";            // Dateiname der geöffnet wird
  char zeilenBuffer[18];                        // Länge der Zeile, danach wird abgeschnitten
  char auswerteBuffer[4][5];                    // Anzahl der Werte pro Zeile, Länge pro Wert
  File myFile;

  // Sx Parameter
  #include "SXArduino.h"                        // Lib einbinden
  SXArduino SXbus(2,4,6,3);                     // Pinbelegung FK (Takt, Daten, Schreiben, Schreiben)
  // SXArduino SXbus(2,4,3,6);                  // Pinbelegung openSX(Takt, Daten, Schreiben, Schreiben)
  bool noCC2000 = false;                        // false 0 ... 103, true 0 ... 111
  
  // LCD Parameter
  #include <LiquidCrystal.h>                    // binden Bibliothek LiquidCrystal ein
  LiquidCrystal lcd(A0, A1, A2, A3, A4, A5);    // Pins festlegen

  byte DecAdr=10;                               // Decoder Adresse
  // byte SxAdr1=0;                             // Sx Adresse 1
  byte SxData1=0;                               // aktuelle SxDaten 1                  
  byte Vergleich=0;
  // int  OldSxData1=6;                         // altes Byte 1
  byte SxAdrSchreib=0;                          // SxAdressen die geschrieben werden 
  byte SxDataSchreib=0;                         // SxDaten die geschrieben werden  
  byte tb=123;                                  // Gleisbit
  // byte oldtb;                                   // alter Wert Gleisbit 
  // String daten;
  byte aktLok;                                  // akt Lok-Nummer in SRC60

void sxisr(void) 
    { 
    SXbus.isr();
    } 

void setup() 
    {
    lcd.begin(16, 2);                           // Display konfigurieren
    SPI.begin();                                // SPI starten
    rfid.init();                                // rfid starten
    // pinMode(Bit_3,OUTPUT);                      // D5 als Ausgang setzen
    // pinMode(Bit_4,OUTPUT);                      // D7 als Ausgang setzen
    // pinMode(Bit_5,OUTPUT);                      // D8 als Ausgang setzen   
    pinMode(SS, OUTPUT);
    // Serial.begin(115200);                    // Baudrate festlegen
    lcd.clear();                                // LCD löscchen
    lcd.setCursor( 1 , 0 );                     // Cursor positionieren
    lcd.print("RFID Zugident   ");              // schreibe
    lcd.setCursor( 1 , 1 );
    lcd.print("by Frank Keil"); 
    delay(3000);
    lcd.clear();                                // LCD löscchen
    while (!Serial)
       // lcd.setCursor( 0 , 0 );                  // Cursor positionieren
       lcd.print("Ini SD card.....");              // schreibe   
      // Serial.print("Initializing SD card...");
      if (!SD.begin(chipSelectPin))
        {
        lcd.setCursor( 0 , 1 );                     // Cursor positionieren
        lcd.print("Ini SD fehlgeschl");             // schreibe
        // Serial.println("Initialisierung fehlgeschlagen!");
        // while (1);
        }
    // lcd.setCursor( 0 , 1 );                     // Cursor positionieren
    // lcd.print("Ini SD ok       ");                     // schreibe      
    // Serial.println("Initialisierung abgeschlossen .");
    myFile = SD.open(filename);
    // Serial.print(filename);
    if (myFile)
        {
        // Serial.println(F(" geöffnet!"));
        lcd.clear();
        // lcd.setCursor( 0 , 0 );
        lcd.print("lese SD-Karte   ");                // schreibe    
        while (myFile.available())
            {
            leseZeile();
            // ausgabeZeile();
            teileZeile();
            ausgabeWerte();
            }
        // schließe die Datei:
        myFile.close();
        // Serial.println(F(" geschlossen!"));
        // while (1);
        }
    else
        {
        // Wenn die Datei nicht geöffnet wurde, drucke einen Fehler :
        // Serial.print("Fehler beim öffnen von ");
        // Serial.println(filename);
        lcd.setCursor( 0 , 0 );               // Cursor positionieren
        lcd.print("Fehler SD card..");        // schreibe   
        }     
    delay(2500);                              // warte x msec
    DecAdr = EEPROM.read(1);                  // EEprom Zelle 1 auslesen
    SXbus.init();                             // SX-bus Kommunikation
    attachInterrupt(0, sxisr, RISING);        // wechsel INT0 triggers the interrupt routine sxisr (see above)
    lcd.clear();                              // LCD löscchen
    // lcd.setCursor( 0 , 0 );                // Cursor positionieren
    lcd.print("EEprom auslesen ");            // schreibe
    for (i=0; i < 100; i++)                   // Schleife einlesen der Daten aus EEprom
        {
        lcd.setCursor( 1 , 1 );
        lcd.print(i); 
        UIDhigh=EEPROM.read(100+i);           // EEprom Zelle 1xx auslesen
        UIDlow =EEPROM.read(200+i);           // EEprom Zelle 2xx auslesen
        ZugIDNr[i]=UIDhigh*256+UIDlow;        // berechnete ZugIdentNummer
        LokAdrNr[i]=EEPROM.read(300+i);       // EEprom Zelle 3x auslesen -> SxAdresse Lok
        // GleisNr[i]=EEPROM.read(400+i);     // EEprom Zelle 4x auslesen -> nicht benutzt nur wenn Züge immer an der selben Stelle stehen
        delay(20);
        /*
        Serial.println(i);                    // Ausgabe
        Serial.print("UIDhigh: ");            // Ausgabe
        Serial.println(UIDhigh);              // Ausgabe
        Serial.print("UIDlow : ");            // Ausgabe
        Serial.println(UIDlow);               // Ausgabe
        Serial.print("ZugIDNr: ");            // Ausgabe
        Serial.println(ZugIDNr[i]);           // Ausgabe
        Serial.print("LokAdrNr: ");           // Ausgabe
        Serial.println(LokAdrNr[i]);          // Ausgabe      
        // Serial.print("GleisNr: ")          // nicht benutzt
        // Serial.print(GleisNr[i]);          // nicht benutzt
        */
        }
    lcd.clear();                                // LCD löscchen
    // lcd.setCursor( 0 , 0 );                  // Cursor setzen
    lcd.print("Bereit          ");              // schreibe      
    }

void loop() 
    {     
    /*  Kann die Lokadressen in die Gleisadressen schreiben
    if (first == 0 && tb == 1)                  // wird nur beim ersten einschalten durch laufen
        {                                       // und schreibt die Loknummern in die Adressen
        Serial.println("jetzt");
        first = 1;                              // wird beim ersten Durchgang gesetzt
        delay(2000);                            // warte 2 sec damit zuerst die Belegtmelder ausgelesen werden können    
        EEprom_auslesen_Sx_schreiben();         // Unterprogrammaufruf     
        }  
    */
      
    if(rfid.isCard())                           // Karte erkannt                     
        {
        if(rfid.readCardSerial())               // lese UID
            {
            // UID=(rfid.serNum[1]+rfid.serNum[2]+rfid.serNum[3]+rfid.serNum[4]);
            UID=(256*rfid.serNum[1]+rfid.serNum[2]);
            b1 = rfid.serNum[1];                // b1 wird UID Byte1
            b2 = rfid.serNum[2];                // b2 wird UID Byte2
            b3 = rfid.serNum[3];                // b3 wird UID Byte3
            b4 = rfid.serNum[4];                // b4 wird UID Byte4
            /*
            Serial.println(b1);                 // serielle Ausgabe
            Serial.println(b2);                 // serielle Ausgabe
            Serial.println("");                 // serielle Ausgabe
            Serial.println(b3);                 // serielle Ausgabe
            Serial.println(b4);                 // serielle Ausgabe
            Serial.println(UID);                // serielle Ausgabe
            Serial.println("");                 // serielle Ausgabe
            */
            }
        }
    rfid.halt();                                //
                        
    if (oldUID != UID)                          // neue UID ?
        {
        oldUID = UID;                           // dann ist die neue die alte
            for (i=1; i < 100; i++)             // Schleife einlesen der Daten aus EEprom
                {
                if (UID == ZugIDNr[i])
                    {
                    SxData1 = LokAdrNr[i];      // Lokadresse
                    aktLok = i;                 // aktuelle Loknummer
                    // LokNr=EEPROM.read(400+i);// nicht benutzt
                    break;                      // vorzeitiges beenden wenn Nummer gefunden
                    }
                }        
            // Serial.println(SxData1);         // serielle Ausgabe
            // Serial.println("neu"); 
            SxAdrSchreib = DecAdr;              // Sx Adresse die beschrieben werden soll
            SxDataSchreib= SxData1;             // setze Wert der geschrieben werden soll
            // Serial.print("SxAdr..: ");       // Ausgabe
            // Serial.println(SxAdrSchreib);    // Ausgabe
            // Serial.print("SxData.: ");       // Ausgabe
            // Serial.println(SxDataSchreib);   // Ausgabe      
            Schreiben();                        // ins Unterprog springen        
            
        /*
        else
            {
            Serial.print(char(10));
            Serial.print(char(b1));
            Serial.print(char(b2));
            Serial.print(char(b3));
            Serial.print(char(b4));
            // Serial.print(char(b5));
            delay(1000);
            // Serial.print(char(112));           // RFID Leser belegt
            // Serial.print(char(12));            // RFID Leser belegt
            // delay(1000);
            Serial.print(char(128));              // RFID Leser frei Meldung
            Serial.print(char(12));               // RFID Leser frei Meldung
            delay(1000);                          // warte
            } 
        */        
        lcd.clear();                              // LCD löschen
        // lcd.setCursor( 0 , 0 );
        lcd.print("UID: ");                       // schreibe
        //lcd.print(UID);                         // schreibe
        //lcd.print(";");                         // schreibe
        lcd.print(b1);                            // schreibe
        lcd.print(",");                           // schreibe
        lcd.print(b2);                            // schreibe  
        // lcd.print(",");                        // schreibe
        // lcd.print(b3);                         // schreibe  
        // lcd.print(",");                        // schreibe
        // lcd.print(b4);                         // schreibe       
        lcd.setCursor( 0 , 1 ); 
        lcd.print("Lok: ");                       // schreibe
        lcd.print(aktLok);                        // schreibe
        lcd.setCursor( 9 , 1 );
        lcd.print("Adr: ");                       // schreibe
        lcd.print(SxData1);                       // schreibe
        }
    
    // Programmierroutine
    if (progAkt == 0)                                 // wenn progAktiv nicht gesetzt
        {
        tb = SXbus.readPWR();                         // Info, ob das Gleissignal an/aus ist
        Prog = analogRead(analogPin);                 // read the input pin 
        if (Prog <= 500 && tb ==false)                // falls gedrückt und Gleis aus
            {
            SxData1 = SXbus.read(106);                // Sx-Adr 106 auslesen
            Vergleich = SxData1 & B00100000;          // Prog schon von anderem Decoder gesetzt?
            if (Vergleich != 32)
                {
                progAkt = 1;                          // setze progAktiv 
                lcd.clear();                          // Display löschen
                lcd.print("Prog-Mode ");              // schreibe
                lcd.setCursor( 0 , 1 );
                lcd.print("DecoderAdr: ");            // schreibe
                SxDataSchreib = SxData1 | B00100000;  // Prog-Bit setzen
                SxAdrSchreib = 106;                   // Sx Adresse die beschrieben werden soll
                Schreiben();                          // ins Unterprog springen
                delay (500);                          // warte
                SxData1=SXbus.read(0);                // Sx-Adr 00 auslesen
                EEPROM.write(10,SxData1);             // und in eEprom retten           
                DecAdr = EEPROM.read(1);              // EEprom Zelle 1 auslesen
                lcd.print(DecAdr);                    // schreibe
                SxAdrSchreib=0;                       // Sx Adresse die beschrieben werden soll
                SxDataSchreib=DecAdr;                 // setze Wert der geschrieben werden soll
                Schreiben();                          // ins Unterprog springen
                }            
            else
                { 
                lcd.clear();                          // Display löschen
                lcd.print("Prog belegt");             // schreibe
                /*
                digitalWrite(Bit_16,HIGH);            // Led einschalten
                delay (800);                          // warte
                digitalWrite(Bit_16,LOW);             // Led ausschalten
                delay (800);                          // warte
                digitalWrite(Bit_16,HIGH);            // Led einschalten
                delay (800);                          // warte
                digitalWrite(Bit_16,LOW);             // Led ausschalten
                delay (800);                          // warte
                digitalWrite(Bit_16,HIGH);            // Led einschalten
                delay (800);                          // warte
                digitalWrite(Bit_16,LOW);             // Led ausschalten 
                */
                }
            delay (1500);                             // warte
            }
        } 
    
    if (progAkt == 1)                                 // wenn progAktiv gesetzt
        {
        tb = SXbus.readPWR();                         // Info, ob das Gleissignal an/aus ist              
        Prog = analogRead(analogPin);                 // read the input pin 
        if (Prog <= 500 || tb ==true)                 // falls gedrückt oder Gleis ein
            {
            // Serial.println("Start speichern");
            DecAdr=SXbus.read(0);                     // Sx-Adr 00 auslesen
            EEPROM.write(1,DecAdr);                   // in eEprom schreiben
            SxDataSchreib = EEPROM.read(10);          // EEprom Zelle 10 mit geretteten auslesen
            SxAdrSchreib=0;                           // Sx Adresse die beschrieben werden soll
            Schreiben();                              // ins Unterprog springen           
            SxData1=SXbus.read(106);                  // Sx-Adr 106 auslesen
            SxDataSchreib=SxData1 & B11011111;        // Prog-Bit zurück setzen
            SxAdrSchreib=106;                         // Sx Adresse die beschrieben werden soll
            Schreiben();                              // ins Unterprog springen
            delay (1000);                             // warte
            progAkt = 0;                              // lösche progAktiv
            // Serial.println("Prog Aus");
            lcd.clear();                              // Display löschen
            lcd.print("Prog beendet ");               // schreibe
            lcd.setCursor( 0 , 1 );
            lcd.print("DecoderAdr: ");                // schreibe
            lcd.print(DecAdr);                        // schreibe
            delay(2000);
            lcd.clear();                                // LCD löscchen
            lcd.print("Bereit          ");              // schreibe      
            }
        }
    }
    
void Schreiben()
    {    
    SXbus.write(SxAdrSchreib,SxDataSchreib);          // Decoderadr auf Sx-Bus in Adr 0 schreiben
    } 

void leseZeile()
  {
  char myChar = '\0';
  static byte bufferPosition = 0;
  if (bufferPosition == 0) memset(zeilenBuffer, '\0', sizeof(zeilenBuffer));
  while (myFile.available() && myChar != '\n')
    {
    myChar = myFile.read();
    if (isPrintable(myChar))
      {
      zeilenBuffer[bufferPosition] = myChar;
      bufferPosition++;
      }
    }
  // Hier ist ZeilenEnde / DateiEnde
  bufferPosition = 0;
  }

/*
void ausgabeZeile()
  {
  // Serial.print(F("eingelsene Zeile ist: "));
  // Serial.println(zeilenBuffer);
  }
*/

void teileZeile()
  {
  // zeilenbuffer in auswerteBuffer umschreiben
  var1 = atoi(strtok(zeilenBuffer, ";"));
  var2 = atoi(strtok(NULL, ";"));
  var3 = atoi(strtok(NULL, ";"));
  var4 = atoi(strtok(NULL, ";"));
  }

void ausgabeWerte()
  {
  lcd.setCursor( 0 , 1 );
  lcd.print(var1);                // schreibe           
  // Serial.println(var1);  
  // Serial.println(var2);
  // Serial.println(100+var1);    //
  EEPROM.write(100+var1,var2);    // in eEprom schreiben
  delay(30);
  // Serial.println(var3);
  // Serial.println(200+var1);    //
  EEPROM.write(200+var1,var3);    // in eEprom schreiben
  delay(30);
  // Serial.println(var4);
  // Serial.println(300+var1);    //
  EEPROM.write(300+var1,var4);    // in eEprom schreiben
  delay(20);
  // Serial.println("");
  }

/*
void EEprom_auslesen_Sx_schreiben()                   // Unterprogramm
    {
    for (i=1; i < 100; i++)                           // Schleife für Schattenbhf
        {       
        if (GleisNr[i] > 0 && GleisNr[i] < 100)       // wenn GleisNr > 0 oder <100  
            {
            SxAdrSchreib=GleisNr[i];
            SxDataSchreib=i;
            Schreiben();                              // Unterprogrammaufruf
            // Serial.print("GleisNr..: ");           // Ausgabe
            // Serial.println(GleisNr[i]);            // Ausgabe
            // Serial.print("Lok....: ");             // Ausgabe
            // Serial.println(i);                     // Ausgabe
            delay(200);                               // warte
            }
        }
    }
    */
