/*  
 *  File:       SxNano_4Signale_PWM_V33.ino
 *  Autor:      Frank Keil
 *  Controller: Arduino Nano (5V, 16MHz), ATmega328
 *  Hardware:   Sx-Decoder von Frank Keil 
 *              http://frank-keil.de/Selectrix/Sx-Decoder/Sx-Decoder.html
 *  
 *  Libraries:  SXArduino: Quellen von G.v.d.Sel  
 *              https://github.com/gvandersel/SXArduino
 *
 *  Created on: 02.01.2012
 *  Last changed on: 03.11.2022
 *  
 *  Beschreibung:
 *  Anzeige von 4 Bits einer Sx-Adresse. 
 *  8 Leds, die Leds werden auf/ab gedimmt
 *  
 *  Pin2=T0=INT0, Pin4=T1, Pin3=SX-Write-High, Pin6=SX-Write-Low
 *
 *  Zum Programmieren des Moduls am Sx-Bus können die SX-Kanäle 0 bis 5 verwendet werden:
 *   Sx-Kanal 0 : Sx-Adresse 1 dieses Moduls (0..99)
 *   Sx-Kanal 1 : FadeZeit Aus (0..255)
 *   Sx-Kanal 2 : FadeZeit An (0..255)
 *   Sx-Kanal 3 : Wartezeit bis LED wieder an geht(0..255)
 *   Sx-Kanal 4 : -
 *   Sx-Kanal 5 : -
 *  Die alten Daten auf dem Bus werden gerettet und zurück geschrieben.
 *   
 *  Bit_7 signalisiert wenn das Prog-Bit schon gesetzt ist
 *  Bit_8 ist während der Programmierung an
 *
 */

  #include "SXArduino.h"                              // Lib einbinden
  SXArduino SXbus(2,4,6,3);                           // Pinbelegung FK (Takt, Daten, Schreiben, Schreiben)
  // SXArduino SXbus(2,4,3,6);                        // Pinbelegung openSX(Takt, Daten, Schreiben, Schreiben)
  bool noCC2000 = false;                              // false 0 ... 103, true 0 ... 111

  #include <EEPROM.h>                                 // EEPROM Bibliothek hinzufügen

  #include <SoftPWM.h>                                // SoftPwm Bibliothek hinzufügen

  // gemeinsame Masse
  SOFTPWM_DEFINE_CHANNEL(0, DDRD, PORTD, PORTD0);     //Arduino pin 0
  SOFTPWM_DEFINE_CHANNEL(1, DDRD, PORTD, PORTD1);     //Arduino pin 1
  // SOFTPWM_DEFINE_CHANNEL(2, DDRD, PORTD, PORTD2);  //Arduino pin 2
  // SOFTPWM_DEFINE_CHANNEL(3, DDRD, PORTD, PORTD3);  //Arduino pin 3
  // SOFTPWM_DEFINE_CHANNEL(4, DDRD, PORTD, PORTD4);  //Arduino pin 4
  SOFTPWM_DEFINE_CHANNEL(5, DDRD, PORTD, PORTD5);     //Arduino pin 5
  // SOFTPWM_DEFINE_CHANNEL(6, DDRD, PORTD, PORTD6);  //Arduino pin 6
  SOFTPWM_DEFINE_CHANNEL(7, DDRD, PORTD, PORTD7);     //Arduino pin 7
  SOFTPWM_DEFINE_CHANNEL(8, DDRB, PORTB, PORTB0);     //Arduino pin 8
  SOFTPWM_DEFINE_CHANNEL(9, DDRB, PORTB, PORTB1);     //Arduino pin 9
  SOFTPWM_DEFINE_CHANNEL(10, DDRB, PORTB, PORTB2);    //Arduino pin 10
  SOFTPWM_DEFINE_CHANNEL(11, DDRB, PORTB, PORTB3);    //Arduino pin 11
  SOFTPWM_DEFINE_CHANNEL(12, DDRB, PORTB, PORTB4);    //Arduino pin 12
  SOFTPWM_DEFINE_CHANNEL(13, DDRB, PORTB, PORTB5);    //Arduino pin 13
  SOFTPWM_DEFINE_CHANNEL(14, DDRC, PORTC, PORTC0);    //Arduino pin A0
  SOFTPWM_DEFINE_CHANNEL(15, DDRC, PORTC, PORTC1);    //Arduino pin A1
  SOFTPWM_DEFINE_CHANNEL(16, DDRC, PORTC, PORTC2);    //Arduino pin A2
  SOFTPWM_DEFINE_CHANNEL(17, DDRC, PORTC, PORTC3);    //Arduino pin A3
  SOFTPWM_DEFINE_CHANNEL(18, DDRC, PORTC, PORTC4);    //Arduino pin A4
  SOFTPWM_DEFINE_CHANNEL(19, DDRC, PORTC, PORTC5);    //Arduino pin A5

  /*
  gemeinsamer plus
  SOFTPWM_DEFINE_CHANNEL_INVERT(0, DDRD, PORTD, PORTD0);  //Arduino pin 0
  SOFTPWM_DEFINE_CHANNEL_INVERT(1, DDRD, PORTD, PORTD1);  //Arduino pin 1
  // SOFTPWM_DEFINE_CHANNEL(2, DDRD, PORTD, PORTD2);      //Arduino pin 2
  // SOFTPWM_DEFINE_CHANNEL(3, DDRD, PORTD, PORTD3);      //Arduino pin 3
  // SOFTPWM_DEFINE_CHANNEL(4, DDRD, PORTD, PORTD4);      //Arduino pin 4
  SOFTPWM_DEFINE_CHANNEL_INVERT(5, DDRD, PORTD, PORTD5);  //Arduino pin 5
  // SOFTPWM_DEFINE_CHANNEL(6, DDRD, PORTD, PORTD6);      //Arduino pin 6
  SOFTPWM_DEFINE_CHANNEL_INVERT(7, DDRD, PORTD, PORTD7);  //Arduino pin 7
  SOFTPWM_DEFINE_CHANNEL_INVERT(8, DDRB, PORTB, PORTB0);  //Arduino pin 8
  SOFTPWM_DEFINE_CHANNEL_INVERT(9, DDRB, PORTB, PORTB1);  //Arduino pin 9
  SOFTPWM_DEFINE_CHANNEL_INVERT(10, DDRB, PORTB, PORTB2); //Arduino pin 10
  SOFTPWM_DEFINE_CHANNEL_INVERT(11, DDRB, PORTB, PORTB3); //Arduino pin 11
  SOFTPWM_DEFINE_CHANNEL_INVERT(12, DDRB, PORTB, PORTB4); //Arduino pin 12
  SOFTPWM_DEFINE_CHANNEL_INVERT(13, DDRB, PORTB, PORTB5); //Arduino pin 13
  SOFTPWM_DEFINE_CHANNEL_INVERT(14, DDRC, PORTC, PORTC0); //Arduino pin A0
  SOFTPWM_DEFINE_CHANNEL_INVERT(15, DDRC, PORTC, PORTC1); //Arduino pin A1
  SOFTPWM_DEFINE_CHANNEL_INVERT(16, DDRC, PORTC, PORTC2); //Arduino pin A2
  SOFTPWM_DEFINE_CHANNEL_INVERT(17, DDRC, PORTC, PORTC3); //Arduino pin A3
  SOFTPWM_DEFINE_CHANNEL_INVERT(18, DDRC, PORTC, PORTC4); //Arduino pin A4
  SOFTPWM_DEFINE_CHANNEL_INVERT(19, DDRC, PORTC, PORTC5); //Arduino pin A5
  */
  
  SOFTPWM_DEFINE_OBJECT(20);
 // byte fade_up;
 // byte fade_down;
  byte wertAus;                               // Wartezeit Aus
  byte wertAn;                                // Wartezeit An
  byte wertWarte;                             // Auszeit
  byte Pin;

  int analogPin = 6;                          // Progtaster
  
  #define Bit_1 1                             // Led 1
  #define Bit_2 0                             // Led 2
  #define Bit_3 5                             // Led 3
  #define Bit_4 7                             // Led 4
  #define Bit_5 8                             // Led 5
  #define Bit_6 9                             // Led 6
  #define Bit_7 10                            // Led 7
  #define Bit_8 11                            // Led 8
  /*
  #define Bit_15 12                           // Bit_15 Led - Gleis ein
  #define Bit_16 13                           // Bit_16 Led - Prog aktiv
  */
  
  byte DecAdr=10;                             // Decoder Adresse
  byte SxAdr1=10;                             // Sx Adresse 1
  byte SxData1=0;                             // aktuelle SxDaten 1                  
  byte OldSxData1[8];                         // altes Byte 1
  byte SxAdrSchreib=0;                        // SxAdressen die geschrieben werden 
  byte SxDataSchreib=0;                       // SxDaten die geschrieben werden  
  byte tb;                                    // Gleisbit
  byte oldtb;                                 // alter Wert Gleisbit
  int  progAkt=0;                             // Programmierung aktiv
  int  Prog = 0;                              // Analogwert Progtaster
  byte Vergleich=0;                           // separieren des Prog-Bits
  byte val;                                   // Info ob Bit high or low
  byte j;                                     // Zählvariable
  
void sxisr(void) 
    { 
    SXbus.isr();
    } 

void setup() 
    {
    // Serial.begin(115200);                      // Baudrate
    /*
    pinMode(Bit_1,OUTPUT);                          // D0 als Ausgang setzen
    pinMode(Bit_2,OUTPUT);                          // D1 als Ausgang setzen
    pinMode(Bit_3,OUTPUT);                          // D5 als Ausgang setzen
    pinMode(Bit_4,OUTPUT);                          // D7 als Ausgang setzen
    pinMode(Bit_5,OUTPUT);                          // D8 als Ausgang setzen
    pinMode(Bit_6,OUTPUT);                          // D9 als Ausgang setzen
    pinMode(Bit_7,OUTPUT);                          // D10 als Ausgang setzen
    pinMode(Bit_8,OUTPUT);                          // D11 als Ausgang setzen
    pinMode(Bit_15,OUTPUT);                         // D12 als Ausgang setzen
    pinMode(Bit_16,OUTPUT);                         // D13 als Ausgang setzen
    */
    DecAdr = EEPROM.read(1);                      // EEprom Zelle 1 auslesen
    wertAn = EEPROM.read(2);                      // EEprom Zelle 2 auslesen
    wertAus = EEPROM.read(3);                     // EEprom Zelle 3 auslesen            
    wertWarte = EEPROM.read(4);                   // EEprom Zeile 4 auslesen
    delay(500);                                   // warte xxx msec
    SXbus.init();                                 // SX-bus Kommunikation
    attachInterrupt(0, sxisr, RISING);            // wechsel INT0 triggers the interrupt routine sxisr (see above)
    Palatis::SoftPWM.begin(60);                   // begin with 60hz pwm frequency
    Palatis::SoftPWM.set(Bit_1, 250);
    Palatis::SoftPWM.set(Bit_2, 0);
    Palatis::SoftPWM.set(Bit_3, 250);
    Palatis::SoftPWM.set(Bit_4, 0);
    Palatis::SoftPWM.set(Bit_5, 250);
    Palatis::SoftPWM.set(Bit_6, 0);
    Palatis::SoftPWM.set(Bit_7, 250);
    Palatis::SoftPWM.set(Bit_8, 0);
    }

void loop() 
    {
    /*
    tb = SXbus.readPWR();                           // Info, ob das Gleissignal an/aus ist
        if (oldtb != tb)                            // Gleisbit geändert?
            {
            oldtb = tb;                             // Gleisbit gleich setzen
            digitalWrite(Bit_15,tb);                // Led je nach Zustand ein/ausschalten
            // Serial.println(tb);                  // Ausgabe
            }
    */
       
    SxData1=SXbus.read(DecAdr);                     // überprüfen ob sich etwas geändert hat
    if (OldSxData1 != SxData1)                      // Daten haben sich auf dem Bus geändert ?
        {
        // Serial.println(SxData1);                 // Ausgabe
        for (byte j = 0; j < 4; j++)
            {
            if (bitRead(OldSxData1[j], j) != bitRead(SxData1, j))   // Bit geändert?
                {
                val=bitRead(SxData1, j);
                // Serial.println(j);               // Ausgabe
                if (j == 0)                         // 
                    {
                    if (val==1)
                        {
                        Pin=1;
                        AUS();  
                        WARTE();
                        Pin=0;
                        AN();  
                        }
                    else    
                        {
                        Pin=0;
                        AUS();  
                        WARTE();
                        Pin=1;
                        AN();  
                        }
                    }
                    
                if (j == 1)                         // 
                    {
                    if (val==1)
                        {
                        Pin=5;
                        AUS();  
                        WARTE();
                        Pin=7;
                        AN();  
                        }
                    else    
                        {
                        Pin=7;
                        AUS();  
                        WARTE();
                        Pin=5;
                        AN();  
                        }
                    }
                if (j == 2)                         // 
                    {
                    if (val==1)
                        {
                        Pin=8;
                        AUS();  
                        WARTE();
                        Pin=9;
                        AN();  
                        }
                    else    
                        {
                        Pin=9;
                        AUS();  
                        WARTE();
                        Pin=8;
                        AN();  
                        }
                    }
                if (j == 3)                         // 
                    {
                    if (val==1)
                        {
                        Pin=10;
                        AUS();  
                        WARTE();
                        Pin=11;
                        AN();  
                        }
                    else    
                        {
                        Pin=11;
                        AUS();  
                        WARTE();
                        Pin=10;
                        AN();  
                        }
                    }
                OldSxData1[j] = SxData1;              // alt = neu setzen                       
                }           
            }
        }

    // Programmierroutine
     if (progAkt == 0)                                // wenn progAktiv nicht gesetzt
        {
        tb = SXbus.readPWR();                         // Info, ob das Gleissignal an/aus ist
        Prog = analogRead(analogPin);                 // read the input pin    
        if (Prog <= 500 && tb ==false)                // falls gedrückt und Gleis aus
            {
            // Serial.println("Prog an");             // Ausgabe
            SxData1 = SXbus.read(106);                // Sx-Adr 106 auslesen
            Vergleich = SxData1 & B00100000;          // Prog schon von anderem Decoder gesetzt?
            if (Vergleich != 32)
                {
                progAkt = 1;                          // setze progAktiv 
                // digitalWrite(Bit_16,HIGH);         // Led einschalten
                Palatis::SoftPWM.set(13, 0);          // Led einschalten
                // Serial.print("Adr106 Bit5 ein ");  // Ausgabe
                // Serial.println(SxDataSchreib);     // Ausgabe
                SxDataSchreib = SxData1 | B00100000;  // Prog-Bit setzen
                SxAdrSchreib = 106;                   // Sx Adresse die beschrieben werden soll
                // SxDataSchreib=SxData1;             // setze Wert der geschrieben werden soll
                Schreiben();                          // ins Unterprog springen
                delay (500);                          // warte
                SxData1=SXbus.read(0);                // Sx-Adr 00 auslesen
                EEPROM.write(10,SxData1);             // und in eEprom retten           
                SxData1=SXbus.read(1);                // Sx-Adr 01 auslesen
                EEPROM.write(11,SxData1);             // und in eEprom retten 
                SxData1=SXbus.read(2);                // Sx-Adr 02 auslesen
                EEPROM.write(12,SxData1);             // und in eEprom retten 
                SxData1=SXbus.read(3);                // Sx-Adr 03 auslesen
                EEPROM.write(13,SxData1);             // und in eEprom retten 
                SxData1=SXbus.read(4);                // Sx-Adr 04 auslesen
                EEPROM.write(14,SxData1);             // und in eEprom retten 
                SxData1=SXbus.read(5);                // Sx-Adr 05 auslesen
                EEPROM.write(15,SxData1);             // und in eEprom retten 
                // Serial.print("Adr0 zur Überprüfung auslesen: ");
                // Serial.println(SxData1);                 
                DecAdr = EEPROM.read(1);              // EEprom Zelle 1 auslesen
                SxAdrSchreib=0;                       // Sx Adresse die beschrieben werden soll
                SxDataSchreib=DecAdr;                 // setze Wert der geschrieben werden soll
                Schreiben();                          // ins Unterprog springen
                wertAn = EEPROM.read(2);              // EEprom Zelle 2 auslesen
                SxAdrSchreib=1;                       // Sx Adresse die beschrieben werden soll
                SxDataSchreib=wertAn;                 // setze Wert der geschrieben werden soll
                Schreiben();                          // ins Unterprog springen
                wertAus = EEPROM.read(3);             // EEprom Zelle 3 auslesen
                SxAdrSchreib=2;                       // Sx Adresse die beschrieben werden soll
                SxDataSchreib=wertAus;                // setze Wert der geschrieben werden soll
                Schreiben();                          // ins Unterprog springen
                wertWarte = EEPROM.read(4);           // EEprom Zelle 3 auslesen
                SxAdrSchreib=3;                       // Sx Adresse die beschrieben werden soll
                SxDataSchreib=wertWarte;              // setze Wert der geschrieben werden soll
                Schreiben();                          // ins Unterprog springen        
                }            
            else
                {
                Palatis::SoftPWM.set(10, 250);        // Led einschalten
                // Serial.println("Prog ist schon an"); // Ausgabe
                }
            delay (1500);                             // warte
            Palatis::SoftPWM.set(10, 0);              // Led einschalten
                
            // Serial.println(progAkt); 
            }
        } 
    
    if (progAkt == 1)                             // wenn progAktiv gesetzt
        {
        tb = SXbus.readPWR();                     // Info, ob das Gleissignal an/aus ist              
        Prog = analogRead(analogPin);             // read the input pin 
        if (Prog <= 500 || tb ==true)             // falls gedrückt oder Gleis ein
            {
            DecAdr=SXbus.read(0);                 // Sx-Adr 00 auslesen
            EEPROM.write(1,DecAdr);               // in eEprom schreiben
            wertAn=SXbus.read(1);                 // Sx-Adr 01 auslesen
            EEPROM.write(2,wertAn);               // in eEprom schreiben
            wertAus=SXbus.read(2);                // Sx-Adr 02 auslesen
            EEPROM.write(3,wertAus);              // in eEprom schreiben          
            wertWarte=SXbus.read(3);              // Sx-Adr 03 auslesen
            EEPROM.write(4,wertWarte);            // in eEprom schreiben                
            SxDataSchreib = EEPROM.read(10);      // EEprom Zelle 10 mit geretteten auslesen
            SxAdrSchreib=0;                       // Sx Adresse die beschrieben werden soll
            Schreiben();                          // ins Unterprog springen           
            SxDataSchreib = EEPROM.read(11);      // EEprom Zelle 11 mit geretteten auslesen
            SxAdrSchreib=1;                       // Sx Adresse die beschrieben werden soll
            Schreiben();                          // ins Unterprog springen           
            SxDataSchreib = EEPROM.read(12);      // EEprom Zelle 12 mit geretteten auslesen
            SxAdrSchreib=2;                       // Sx Adresse die beschrieben werden soll
            Schreiben();                          // ins Unterprog springen           
            SxDataSchreib = EEPROM.read(13);      // EEprom Zelle 13 mit geretteten auslesen
            SxAdrSchreib=3;                       // Sx Adresse die beschrieben werden soll
            Schreiben();                          // ins Unterprog springen           
            SxDataSchreib = EEPROM.read(14);      // EEprom Zelle 14 mit geretteten auslesen
            SxAdrSchreib=4;                       // Sx Adresse die beschrieben werden soll
            Schreiben();                          // ins Unterprog springen           
            SxDataSchreib = EEPROM.read(15);      // EEprom Zelle 15 mit geretteten auslesen
            SxAdrSchreib=5;                       // Sx Adresse die beschrieben werden soll
            Schreiben();                          // ins Unterprog springen           
            SxData1=SXbus.read(106);              // Sx-Adr 106 auslesen
            SxDataSchreib=SxData1 & B11011111;    // Prog-Bit zurück setzen
            SxAdrSchreib=106;                     // Sx Adresse die beschrieben werden soll
            Schreiben();                          // ins Unterprog springen
            delay (1000);                         // warte
            progAkt = 0;                          // lösche progAktiv
            // digitalWrite(Bit_16,LOW);          // Led ausschalten
            Palatis::SoftPWM.set(13, 255);        // Led ausschalten
            // Serial.println("Prog aus");        // Ausgabe
            }
        }
    }

void Schreiben()
    {    
    SXbus.write(SxAdrSchreib,SxDataSchreib);      // Decoderadr auf Sx-Bus in Adr 0 schreiben
    }

void AN()
    {    
    unsigned long nextMicros = 0;             
    for (int v = 0; v < 250 - 1; ++v) 
        {
        while (micros() < nextMicros);
        nextMicros = micros() + wertAn*20;
        Palatis::SoftPWM.set(Pin, v);
        }         
    }

void AUS()
    {    
    unsigned long nextMicros = 0;             
    for (int v = 250 - 1; v >= 0; --v) 
        {
        while (micros() < nextMicros);
        nextMicros = micros() + wertAus*20;
        Palatis::SoftPWM.set(Pin, v);
        }        
    }

void WARTE()  
    {
    //unsigned long nextMicros = 0;
    //while (micros() < nextMicros);
    //nextMicros = micros() + wertWarte*20;
    delay(wertWarte*5);
    }
                          
